package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.receive;
import java.math.BigInteger;

import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "новой фразы в составе синхронизированной ранее группы с отклоненной новой фразой (2)")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewPhraseInSyncedGroupWithDeclinedPhraseTest2
        extends BsResponseHandlingForNewPhraseInSyncedGroupWithDeclinedPhraseBaseTest {

    @Test
    @Title("Изменения после успешной отправки кампании с новой фразой в синхронизированной ранее группе " +
            "(присутствуют не принятые фразы) - статус statusBsSynced Баннера")
    public void testBannerSyncStatusAfterTransmissionForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        BannersRecord dbBanner = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid);
        assertThat("после синхронизации баннера statusBsSynced = Yes",
                dbBanner.getStatusbssynced().getLiteral(), equalTo(Status.YES));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новой фразой в синхронизированной ранее группе " +
            "(присутствуют не принятые фразы) - OrderID Кампании")
    public void testOrderIdAfterTransmissionForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        CampaignsRecord dbCampaign =  api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid);
        assertThat("правильный OrderID у кампании после синхронизации",
                dbCampaign.getOrderid(), equalTo(Long.valueOf(campaign.getId())));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новой фразой в синхронизированной ранее группе " +
            "(присутствуют не принятые фразы) - PhraseID Фразы (принятой)")
    public void testPhraseIdAfterTransmissionForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        BidsRecord acceptedPhraseDb = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsSteps().getBidById(acceptedBidsId);
        assertThat("правильный PhraseID у фразы после синхронизации",
                acceptedPhraseDb.getPhraseid(), equalTo(new BigInteger(acceptedPhrase.getId())));
    }

    @Test
    @Title("Изменения после успешной отправки кампании с новой фразой в синхронизированной ранее группе " +
            "(присутствуют не принятые фразы) - BannerID Баннера")
    public void testBannerIdAfterTransmissionForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        BannersRecord dbBanner = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid);
        assertThat("правильный BannerID у баннера после синхронизации",
                dbBanner.getBannerid(), equalTo(Long.valueOf(banner.getId())));
    }
}
