package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.transmit;

import java.util.Collection;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК фразы в составе новой группы")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPhraseInNewGroupTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;


    private static Long bidsId;

    private static Phrase phraseReq1;

    private static Collection<Phrase> phrasesReq2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaignReq1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context contextReq1 = campaignReq1 != null ? campaignReq1.getContext(pid) : null;
        phraseReq1 = contextReq1 != null ? contextReq1.getPhrase(bidsId) : null;

        Campaign campaignReq2 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        Context contextReq2 = campaignReq2 != null ? campaignReq2.getContext(pid) : null;
        Map<String, Phrase> phraseMap = contextReq2 != null ? contextReq2.getPhrases() : null;
        phrasesReq2 = getMapValues(phraseMap);
    }

    // кампания проверяется в тестах кампаний для соответствующего кейса
    // контекст проверяется в тестах групп для соответствующего кейса
    // баннер проверяется в тестах баннеров для соответствующего кейса

    @Test
    @Title("Отправка в БК новой фразы в новой группе (кампания так же новая) (1 запрос) - " +
            "проверка объекта Фраза")
    public void testTransportOfPhraseObjReq1ForNewPhraseInNewGroup() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        expectedPhrase.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                phraseReq1, beanEquals(expectedPhrase));
    }

    @Test
    @Title("Отправка в БК новой фразы в новой группе (кампания так же новая) (2 запрос) - " +
            " - проверка списка фраз")
    public void testTransportOfPhraseListReq2ForNewPhraseInNewGroup() {
        assertThat("в БК вторым запросом не отправлены фразы", phrasesReq2, nullValue());
    }
}
