package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.transmit;

import java.util.List;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК фразы " +
        "в составе новой группы (присутствует отклоненная фраза)")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPhraseInNewGroupWithDeclinedPhraseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long acceptedBidsId;

    private static Context contextReq1;
    private static List<Phrase> phrasesReq1;
    private static Phrase acceptedPhraseReq1;

    private static Context contextReq2;
    private static List<Phrase> phrasesReq2;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)
                        .withVCardId(vCardId)));
        acceptedBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        Long declinedBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().setStatusModerate(acceptedBidsId, YES);
        api.userSteps.phrasesFakeSteps().setStatusModerate(declinedBidsId, NO);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaignReq1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        contextReq1 = campaignReq1 != null ? campaignReq1.getContext(pid) : null;
        Map<String, Phrase> phraseMapReq1 = contextReq1 != null ? contextReq1.getPhrases() : null;
        phrasesReq1 = getMapValues(phraseMapReq1);
        acceptedPhraseReq1 = contextReq1 != null ? contextReq1.getPhrase(acceptedBidsId) : null;

        Campaign campaignReq2 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        contextReq2 = campaignReq2 != null ? campaignReq2.getContext(pid) : null;
        Map<String, Phrase> phraseMapReq2 = contextReq2 != null ? contextReq2.getPhrases() : null;
        phrasesReq2 = getMapValues(phraseMapReq2);
    }

    // кампания проверяется в тестах кампаний для соответствующего кейса
    // баннер проверяется в тестах баннеров для соответствующего кейса

    @Test
    @Title("Отправка в БК новой фразы в новой группе (кампания так же новая) " +
            "(присутствует отклоненная фраза) (1 запрос) - проверка объекта Контекст")
    public void testTransportOfContextObjReq1ForNewPhrasesInNewGroupWithDeclinedPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                contextReq1, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой фразы в новой группе (кампания так же новая) " +
            "(присутствует отклоненная фраза) (1 запрос) - проверка списка фраз")
    public void testTransportOfPhraseListReq1ForNewPhrasesInNewGroupWithDeclinedPhrase() {
        assertThat("размер отправленного в БК списка фраз соответствует ожидаемому",
                phrasesReq1, hasSize(1));
    }

    @Test
    @Title("Отправка в БК новой фразы в новой группе (кампания так же новая) " +
            "(присутствует отклоненная фраза) (1 запрос) - проверка объекта Фраза (принятая)")
    public void testTransportOfAcceptedPhraseObjReq1ForNewPhrasesInNewGroupWithDeclinedPhrase() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(acceptedBidsId, shard, UpdateInfo.UPDATE);
        expectedPhrase.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                acceptedPhraseReq1, beanEquals(expectedPhrase));
    }

    @Test
    @Title("Отправка в БК новой фразы в новой группе (кампания так же новая) " +
            "(присутствует отклоненная фраза) (2 запрос) - проверка объекта Контекст")
    public void testTransportOfContextObjReq2ForNewPhrasesInNewGroupWithDeclinedPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                contextReq2, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой фразы в новой группе (кампания так же новая) " +
            "(присутствует отклоненная фраза) (2 запрос) - проверка списка фраз")
    public void testTransportOfPhraseListReq2ForNewPhrasesInNewGroupWithDeclinedPhrase() {
        assertThat("в БК вторым запросом не отправлены фразы", phrasesReq2, nullValue());
    }
}
