package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.transmit;

import java.util.List;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК фразы в составе " +
        "синхронизированной группы с отклоненной новой фразой")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPhraseInSyncedGroupWithDeclinedPhraseTest1 {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long bid;
    private static Long pid;
    private static Long syncedBidsId;
    private static Long acceptedBidsId;

    private static Campaign campaign;
    private static Context context;
    private static List<Phrase> phrases;
    private static Phrase syncedPhrase;
    private static Phrase newPhrase;
    private static Banner banner;

    private static Campaign campaignReq2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        syncedBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(syncedBidsId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        List<Long> newKeywordIds = api.userSteps.keywordsSteps().addDefaultKeywords(pid, 2);
        acceptedBidsId = newKeywordIds.get(0);
        long declinedBidsId = newKeywordIds.get(1);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().setStatusModerate(acceptedBidsId, YES);
        api.userSteps.phrasesFakeSteps().setStatusModerate(declinedBidsId, NO);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        Map<String, Phrase> phraseMap = context != null ? context.getPhrases() : null;
        phrases = getMapValues(phraseMap);
        syncedPhrase = context != null ? context.getPhrase(syncedBidsId) : null;
        newPhrase = context != null ? context.getPhrase(acceptedBidsId) : null;

        campaignReq2 = resp.getUuid().length > 1 ?
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid) : null;
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе " +
            "(присутствует отклоненная новая фраза) - проверка объекта Кампания")
    public void testTransportOfCampaignObjForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.SKIP);
        expectedCampaign.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе " +
            "(присутствует отклоненная новая фраза) - проверка объекта Контекст")
    public void testTransportOfContextObjForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе " +
            "(присутствует отклоненная новая фраза) - проверка объекта Баннер")
    public void testTransportOfBannerObjForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        expectedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе " +
            "(присутствует отклоненная новая фраза) - проверка списка Фраз")
    public void testTransportOfPhraseListForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        assertThat("размер отправленного в БК списка фраз соответствует ожидаемому",
                phrases, hasSize(2));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе " +
            "(присутствует отклоненная новая фраза) - проверка объекта Фраза (синхронизированная ранее)")
    public void testTransportOfSyncedPhraseObjForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        Phrase expectedSyncedPhrase = helpSteps.buildExpectedPhraseObjFromDb(syncedBidsId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные синхронизированной фразы соответствуют ожидаемым",
                syncedPhrase, beanEquals(expectedSyncedPhrase));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе " +
            "(присутствует отклоненная новая фраза) - проверка объекта Фраза (принятая)")
    public void testTransportOfNewPhraseObjForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        Phrase expectedNewPhrase = helpSteps.buildExpectedPhraseObjFromDb(acceptedBidsId, shard, UpdateInfo.UPDATE);
        expectedNewPhrase.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                newPhrase, beanEquals(expectedNewPhrase));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе " +
            "(присутствует отклоненная новая фраза) - проверка количества запросов")
    public void testReqNumForNewPhraseInSyncedGroupWithDeclinedPhrase() {
        assertThat("в БК отправлен только один запрос", campaignReq2, nullValue());
    }
}
