package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.transmit;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК фразы в составе синхронизированной группы без фраз")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPhraseInSyncedGroupWithNoPhraseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long bid;
    private static Long retId;
    private static Long pid;
    private static Long bidsId;

    private static Campaign campaign;
    private static Context context;
    private static Phrase phrase;
    private static GoalContext goalContext;
    private static Banner banner;

    private static Campaign campaignReq2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        Long retCondId = helpSteps.addRetargetingListsForUserIfNotExists(login).get(0);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        retId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(login, pid, retCondId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        phrase = context != null ? context.getPhrase(bidsId) : null;
        goalContext = context != null ? context.getGoalContext(retId) : null;

        campaignReq2 = resp.getUuid().length > 1 ?
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid) : null;
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе без фраз - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignObjForNewPhraseInSyncedGroupWithNoPhrase() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.SKIP);
        expectedCampaign.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе без фраз - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjForNewPhraseInSyncedGroupWithNoPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе без фраз - " +
            "проверка объекта Баннер")
    public void testTransportOfBannerObjForNewPhraseInSyncedGroupWithNoPhrase() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        expectedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе без фраз - " +
            "проверка объекта Ретаргетинг (синхронизированный ранее)")
    public void testTransportOfGoalContextObjForNewPhraseInSyncedGroupWithNoPhrase() {
        GoalContext expectedGoalContext = helpSteps.buildExpectedRetargetingObjFromDb(retId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные синхронизированного ретаргетинга соответствуют ожидаемым",
                goalContext, beanEquals(expectedGoalContext));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе без фраз - " +
            "проверка объекта Фраза (новая)")
    public void testTransportOfPhraseObjForNewPhraseInSyncedGroupWithNoPhrase() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        expectedPhrase.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                phrase, beanEquals(expectedPhrase));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе без фраз - " +
            "проверка количества запросов")
    public void testReqNumForNewPhraseInSyncedGroupWithNoPhrase() {
        assertThat("в БК отправлен только один запрос", campaignReq2, nullValue());
    }
}
