package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.transmit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК фразы в составе синхронизированной группы с фразой")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPhraseInSyncedGroupWithPhraseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long bid;
    private static Long pid;
    private static Long syncedBidsId;
    private static Long newBidsId;

    private static Campaign campaign;
    private static Context context;
    private static Phrase syncedPhrase;
    private static Phrase newPhrase;
    private static Banner banner;

    private static Campaign campaignReq2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        syncedBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(syncedBidsId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        newBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(newBidsId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        syncedPhrase = context != null ? context.getPhrase(syncedBidsId) : null;
        newPhrase = context != null ? context.getPhrase(newBidsId) : null;

        campaignReq2 = resp.getUuid().length > 1 ?
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid) : null;
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе с фразой - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignObjForNewPhraseInSyncedGroupWithPhrase() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.SKIP);
        expectedCampaign.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе с фразой - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjForNewPhraseInSyncedGroupWithPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе с фразой - " +
            "проверка объекта Баннер")
    public void testTransportOfBannerObjForNewPhraseInSyncedGroupWithPhrase() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        expectedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе с фразой - " +
            "проверка объекта Фраза (синхронизированная ранее)")
    public void testTransportOfSyncedPhraseObjForNewPhraseInSyncedGroupWithPhrase() {
        Phrase expectedSyncedPhrase = helpSteps.buildExpectedPhraseObjFromDb(syncedBidsId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные синхронизированной фразы соответствуют ожидаемым",
                syncedPhrase, beanEquals(expectedSyncedPhrase));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе с фразой - " +
            "проверка объекта Фраза (новая)")
    public void testTransportOfNewPhraseObjForNewPhraseInSyncedGroupWithPhrase() {
        Phrase expectedNewPhrase = helpSteps.buildExpectedPhraseObjFromDb(newBidsId, shard, UpdateInfo.UPDATE);
        expectedNewPhrase.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                newPhrase, beanEquals(expectedNewPhrase));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе с фразой - " +
            "проверка количества запросов")
    public void testReqNumForNewPhraseInSyncedGroupWithPhrase() {
        assertThat("в БК отправлен только один запрос", campaignReq2, nullValue());
    }
}
