package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.transmit;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.startsWith;
import static ru.yandex.autotests.direct.utils.features.FeatureNameEnum.AUTOTARGETING_KEYWORD_PREFIX_ALLOWED;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК фразы с префиксом ---autotargeting" +
        " в составе новой группы")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPhraseWithAutotargetingInNewGroupTest {

    private static final String login = Logins.LOGIN_TRANSPORT_FEATURES;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long bidsId;

    private static Context contextReq;
    private static Phrase phraseReq;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        long  autotargetingKeywordPrefixAllowedFeatureId = api.userSteps.getDirectJooqDbSteps().featuresSteps()
                .getFeatureId(AUTOTARGETING_KEYWORD_PREFIX_ALLOWED.getValue());
        Long clientId = Long.valueOf(User.get(login).getClientID());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).clientsSteps()
                .setClientFeature(clientId, autotargetingKeywordPrefixAllowedFeatureId, true);

        bidsId = api.userSteps.keywordsSteps().addDefaultKeywordWithAutotargetingPrefix(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        contextReq = campaign != null ? campaign.getContext(pid) : null;
        phraseReq = contextReq != null ? contextReq.getPhrase(bidsId) : null;
    }

    @AfterClass
    public static void afterClass() {
        if (bidsId != null) {
            api.userSteps.keywordsSteps().keywordsDelete(bidsId);
        }
    }


    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе - " +
            "(кампания так же новая) (1 запрос) - проверка объекта Контекст")
    public void testTransportOfContextObjReq1ForNewPhrasesInNewGroupWithDeclinedPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                contextReq, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе - " +
            "(кампания так же новая) (1 запрос) - проверка объекта Фраза")
    public void testTransportOfPhraseText() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        expectedPhrase.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                phraseReq, beanEquals(expectedPhrase));
    }

    @Test
    @Title("Отправка в БК новой фразы в синхронизированной группе - " +
            "(кампания так же новая) (1 запрос) - проверка объекта текста фразы")
    public void testTransportOfPhraseObjForNewPhrasesInNewGroup() {
        assertThat("отправленный в БК текст новой фразы содержит префикс ---autotargeting",
                phraseReq.getText(), startsWith("---autotargeting "));
    }
}
