package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.creation.transmit;

import java.util.Collection;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нескольких фраз в составе новой группы")
@Stories(StoriesNames.PHRASE_ACTION_CREATION)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPhrasesInNewGroupTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long bidsId1;
    private static Long bidsId2;

    private static Context contextReq1;
    private static Phrase phrase1Req1;
    private static Phrase phrase2Req1;

    private static Context contextReq2;
    private static Collection<Phrase> phrasesReq2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)
                        .withVCardId(vCardId)));
        bidsId1 = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        bidsId2 = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId1);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId2);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        contextReq1 = campaign != null ? campaign.getContext(pid) : null;
        phrase1Req1 = contextReq1 != null ? contextReq1.getPhrase(bidsId1) : null;
        phrase2Req1 = contextReq1 != null ? contextReq1.getPhrase(bidsId2) : null;

        Campaign campaignReq2 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        contextReq2 = campaignReq2 != null ? campaignReq2.getContext(pid) : null;
        Map<String, Phrase> phraseMapReq2 = contextReq2 != null ? contextReq2.getPhrases() : null;
        phrasesReq2 = getMapValues(phraseMapReq2);
    }

    @Test
    @Title("Отправка в БК нескольких новых фраз в синхронизированной группе - " +
            "(кампания так же новая) (1 запрос) - проверка объекта Контекст")
    public void testTransportOfContextObjReq1ForNewPhrasesInNewGroupWithDeclinedPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                contextReq1, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нескольких новых фраз в синхронизированной группе - " +
            "(кампания так же новая) (1 запрос) - проверка объекта Фраза 1")
    public void testTransportOfPhrase1ObjForNewPhrasesInNewGroup() {
        Phrase expectedPhrase1 = helpSteps.buildExpectedPhraseObjFromDb(bidsId1, shard, UpdateInfo.UPDATE);
        expectedPhrase1.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                phrase1Req1, beanEquals(expectedPhrase1));
    }

    @Test
    @Title("Отправка в БК нескольких новых фраз в синхронизированной группе - " +
            "(кампания так же новая) (1 запрос) - проверка объекта Фраза 2")
    public void testTransportOfPhrase2ObjForNewPhrasesInNewGroup() {
        Phrase expectedPhrase2 = helpSteps.buildExpectedPhraseObjFromDb(bidsId2, shard, UpdateInfo.UPDATE);
        expectedPhrase2.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                phrase2Req1, beanEquals(expectedPhrase2));
    }

    @Test
    @Title("Отправка в БК нескольких новых фраз в синхронизированной группе - " +
            "(кампания так же новая) (2 запрос) - проверка объекта Контекст")
    public void testTransportOfContextObjReq2ForNewPhrasesInNewGroupWithDeclinedPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                contextReq2, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нескольких новых фраз в синхронизированной группе - " +
            "(кампания так же новая) (2 запрос) - проверка списка фраз")
    public void testTransportOfPhraseListReq2ForNewPhraseInNewGroup() {
        assertThat("в БК вторым запросом не отправлены фразы", phrasesReq2, nullValue());
    }
}
