package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.editing;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.api5.keywords.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки баннеров после изменения фразы")
@Stories(StoriesNames.PHRASE_ACTION_EDITING)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfBannersForEditedPhraseInSyncedGroupTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    private static final String KEYWORD = "панда";
    private static final String ADDITIONAL_KEYWORD = "полосатая";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private static final float PRICE = 40.0f;

    private static Long pid;
    private static Long activeBid;
    private static Long stoppedBid;
    private static Long archivedBid;

    private static Context context;
    private static Banner activeBanner;
    private static Banner stoppedBanner;
    private static Banner archivedBanner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        TextCampaignSearchStrategyAddMap searchStrategy =
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition();

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaignWithSearchStrategy(searchStrategy);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        activeBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        stoppedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        archivedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .withAdGroupId(pid)
                .withKeyword(KEYWORD)
                .withBid(Money.valueOf(PRICE).bidLong().longValue())).get(0);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(activeBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(stoppedBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(archivedBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.adsSteps().adsSuspend(stoppedBid);
        api.userSteps.adsSteps().adsSuspend(archivedBid);
        api.userSteps.adsSteps().adsArchive(archivedBid);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);

        api.userSteps.keywordsSteps().shouldGetResultOn(Action.UPDATE,
                new UpdateRequestMap().withKeywords(new KeywordUpdateMap()
                        .withId(keywordId)
                        .withKeyword(KEYWORD + " " + ADDITIONAL_KEYWORD)),
                ExpectedResult.success(keywordId));

        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        activeBanner = context != null ? context.getBanner(activeBid) : null;
        stoppedBanner = context != null ? context.getBanner(stoppedBid) : null;
        archivedBanner = context != null ? context.getBanner(archivedBid) : null;
    }

    @Test
    @Title("Отправка в БК баннеров после изменения фразы - проверка объекта Контекст")
    public void testTransportOfContextForEditedPhraseInSyncedGroup() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("в БК отправлен контекст", context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК баннеров после изменения фразы - проверка объекта Баннер (активный)")
    public void testTransportOfActiveBannerForEditedPhraseInSyncedGroup() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(activeBid, shard, UpdateInfo.SKIP);
        assertThat("в БК отправлен активный баннер", activeBanner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК баннеров после изменения фразы - проверка объекта Баннер (остановленный)")
    public void testTransportOfStoppedBannerForEditedPhraseInSyncedGroup() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(stoppedBid, shard, UpdateInfo.SKIP);
        assertThat("в БК отправлен остановленный баннер", stoppedBanner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК баннеров после изменения фразы - проверка объекта Баннер (заархивированный)")
    public void testTransportOfArchivedBannerForEditedPhraseInSyncedGroup() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(archivedBid, shard, UpdateInfo.SKIP);
        assertThat("в БК отправлен заархивированный баннер", archivedBanner, beanEquals(expectedBanner));
    }
}
