package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.rejecting.queue.add;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь отклоненных фраз (другие фразы отсутствуют)")
@Stories(StoriesNames.PHRASE_ACTION_REJECTING)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueDeclinedPhrasesWithNoOtherPhrasesTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Добавление в очередь кампании с отклоненными фразами (другие фразы отсутствуют)")
    public void testTransmissionOfCampaignObjForDeclinedPhrasesWithNoOtherPhrases() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)
                        .withVCardId(vCardId)));
        Long bidsId1 = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        Long bidsId2 = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId1);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId2);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusBsSynced(bid, NO);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        api.userSteps.phrasesFakeSteps().setStatusModerate(bidsId1, NO);
        api.userSteps.phrasesFakeSteps().setStatusModerate(bidsId2, NO);
        api.userSteps.groupFakeSteps().setStatusModerate(pid, NO);
        api.userSteps.groupFakeSteps().setStatusPostModerate(pid, NO);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid,
                bid);
        assertThat("Ожидаем, что в БК может быть отправлен баннер", banner, notNullValue());
    }
}
