package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.rejecting.transmit;

import java.util.List;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК отклоненной фразы и принятой")
@Stories(StoriesNames.PHRASE_ACTION_REJECTING)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfDeclinedPhraseWithAcceptedPhraseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long bid;
    private static Long pid;
    private static Long acceptedBidsId;

    private static Campaign campaign;
    private static Context context;
    private static List<Phrase> phraseList;
    private static Phrase phrase;
    private static Banner banner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)
                        .withVCardId(vCardId)));
        acceptedBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        Long declinedBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(acceptedBidsId);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(declinedBidsId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        api.userSteps.phrasesFakeSteps().setStatusModerate(acceptedBidsId, YES);
        api.userSteps.phrasesFakeSteps().setStatusModerate(declinedBidsId, NO);
        api.userSteps.groupFakeSteps().setStatusModerate(pid, YES);
        api.userSteps.groupFakeSteps().setStatusPostModerate(pid, YES);


        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        Map<String, Phrase> phrases = context != null ? context.getPhrases() : null;
        phraseList = getMapValues(phrases);
        phrase = context != null ? context.getPhrase(acceptedBidsId) : null;
        banner = context != null ? context.getBanner(bid) : null;
    }

    @Test
    @Title("Отправка в БК кампании с отклоненной фразой и принятой - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignObjForDeclinedPhraseWithAcceptedPhrase() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные кампании соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК кампании с отклоненной фразой и принятой - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjForDeclinedPhraseWithAcceptedPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с отклоненной фразой и принятой - " +
            "проверка объекта Баннер")
    public void testTransportOfBannerObjForDeclinedPhraseWithAcceptedPhrase() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        expectedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с отклоненной фразой и принятой - " +
            "проверка списка Фраз")
    public void testTransportOfPhraseListForDeclinedPhraseWithAcceptedPhrase() {
        assertThat("размер отправленного в БК списка фраз соответствует ожидаемому",
                phraseList, hasSize(1));
    }

    @Test
    @Title("Отправка в БК кампании с отклоненной фразой и принятой - " +
            "проверка объекта Фраза (принятая)")
    public void testTransportOfPhraseObjForDeclinedPhraseWithAcceptedPhrase() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(acceptedBidsId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные фразы соответствуют ожидаемым",
                phrase, beanEquals(expectedPhrase));
    }
}
