package ru.yandex.autotests.directintapi.bstransport.main.phrase.actions.stopping.transmit;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК остановки фразы")
@Stories(StoriesNames.PHRASE_ACTION_STOPPING)
@Features({FeatureNames.PHRASES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfSuspendedPhraseTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long bidsId;
    private static Long bid;

    private static Context context;
    private static List<Phrase> phrases;
    private static Phrase phrase;
    private static Banner banner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long suspendedBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(suspendedBidsId);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.keywordsSteps().keywordsSuspend(suspendedBidsId);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0
                , cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = getMapValues(context != null ? context.getPhrases() : null);
        phrase = context != null ? context.getPhrase(bidsId) : null;
        banner = context != null ? context.getBanner(bid) : null;
    }

    @Test
    @Title("Отправка в БК остановки фразы - проверка объекта Контекст")
    public void testTransportOfContextObjForSuspendedPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК остановки фразы - проверка списка Фраз")
    public void testTransportOfPhraseListForSuspendedPhrase() {
        assertThat("в БК отправлена только одна фраза", phrases, allOf(notNullValue(), hasSize(1)));
    }

    @Test
    @Title("Отправка в БК остановки фразы - проверка объекта Фраза")
    public void testTransportOfPhraseObjForSuspendedPhrase() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные фразы соответствуют ожидаемым",
                phrase, beanEquals(expectedPhrase));
    }

    @Test
    @Title("Отправка в БК остановки фразы - проверка объекта Баннер")
    public void testTransportOfBannerObjForSuspendedPhrase() {
        Banner expectedPicBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        expectedPicBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные баннера соответствуют ожидаемым",
                banner, beanEquals(expectedPicBanner));
    }
}
