package ru.yandex.autotests.directintapi.bstransport.main.phrase.parameters.bid;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class BsTransportOfBidForNewPhraseInNewGroupBaseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private static final float PRICE = 40.0f;

    private Phrase phrase;

    @Parameterized.Parameter(0)
    public TextCampaignSearchStrategyAddMap strategy;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaignWithSearchStrategy(strategy);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long bidsId = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .defaultKeyword()
                .withAdGroupId(pid)
                .withBid(Money.valueOf(PRICE).bidLong().longValue())).get(0);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        phrase = context != null ? context.getPhrase(bidsId) : null;

        assumeThat("в БК отправлена фраза", phrase, notNullValue());
    }

    @Test
    @Title("Отправка в БК ставки на поиске для новой фразы в новой группе (для ручных стратегий)")
    public void testTransportOfPhraseBidForNewPhraseInNewGroup() {
        assertThat("отправленная в БК ставка на поиске соответствует ожидаемой",
                Float.parseFloat(phrase.getPrice()), equalTo(PRICE));
    }

    @Test
    @Title("Отправка в БК кода валюты для новой фразы в новой группе (для ручных стратегий)")
    public void testTransportOfCurrencyForNewPhraseInNewGroup() {
        assertThat("отправленный в БК код валюты соответствует ожидаемому",
                phrase.getCurrencyIsoCode(), equalTo(Currency.RUB.getIsoCode()));
    }
}
