package ru.yandex.autotests.directintapi.bstransport.main.phrase.parameters.bid;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class BsTransportOfBidForNewPhraseInSyncedGroupBaseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private static final float PRICE = 40.0f;

    private Phrase newPhrase;

    @Parameterized.Parameter(0)
    public TextCampaignSearchStrategyAddMap strategy;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
    }

    @Before
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaignWithSearchStrategy(strategy);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long syncedBidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(syncedBidsId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long newBidsId = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .defaultKeyword()
                .withAdGroupId(pid)
                .withBid(Money.valueOf(PRICE).bidLong().longValue())).get(0);

        api.userSteps.phrasesFakeSteps().makeKeywordModerated(newBidsId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        newPhrase = context != null ? context.getPhrase(newBidsId) : null;

        assumeThat("в БК отправлена новая фраза", newPhrase, notNullValue());
    }

    @Test
    @Title("Отправка в БК ставки на поиске для новой фразы " +
            "в синхронизированной группе (для ручных стратегий)")
    public void testTransportOfPhraseBidForNewPhraseInSyncedGroup() {
        assertThat("отправленная в БК ставка на поиске соответствует ожидаемой",
                Float.parseFloat(newPhrase.getPrice()), equalTo(PRICE));
    }

    @Test
    @Title("Отправка в БК кода валюты для новой фразы " +
            "в синхронизированной группе (для ручных стратегий)")
    public void testTransportOfCurrencyForNewPhraseInSyncedGroup() {
        assertThat("отправленный в БК код валюты соответствует ожидаемому",
                newPhrase.getCurrencyIsoCode(), equalTo(Currency.RUB.getIsoCode()));
    }
}
