package ru.yandex.autotests.directintapi.bstransport.main.relevancematch.actions.creation.queue;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.BidsBaseSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.RelevanceMatch;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 13.03.17.
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Description("Транспорт: проверка отправки в БК бесфразного таргетинга в составе новой группы")
@Stories(StoriesNames.RELEVANCE_MATCH_ACTION)
@Features({FeatureNames.RELEVANCE_MATCH, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-63412")
public class AddingToBsQueueRelevanceMatchInNewTGOGroupTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private Long cid;
    private Long pid;
    private Long bid;
    private Long bidsId;
    private Long relevanceMatchId;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        relevanceMatchId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsBaseSteps()
                .saveDefaultRelevanceMatch(cid, pid, Currency.RUB);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
    }

    @Test
    @Description("Проверка на отправку остановленного бесфразного таргетинга с фразой в новой ТГО группе (кампания " +
            "так же новая)")
    public void testAddingToBsQueueForSuspendedRelevanceMatchAndPhraseInNewGroup() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsBaseSteps()
                .setBidsBaseOpts(relevanceMatchId, BidsBaseSteps.OPTS_SUSPENDED);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
        runAndCheck(false);
    }

    @Test
    @Description("Проверка на отправку остановленного синхронизированного бесфразного таргетинга с фразой в новой ТГО" +
            " группе (кампания так же новая)")
    //Тест фантастический, но свою работу делает
    public void testAddingToBsQueueForSyncedRelevanceMatchAndPhraseInNewGroup() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsBaseSteps()
                .setBidsBaseOpts(relevanceMatchId, BidsBaseSteps.OPTS_SUSPENDED);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
        runAndCheck(false);
    }

    @Test
    @Description("Проверка на отправку удаленного бесфразного таргетинга с фразой в новой ТГО группе(кампания так же " +
            "новая)")
    public void testAddingToBsQueueForDeletedRelevanceMatchAndPhraseInNewGroup() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsBaseSteps()
                .setBidsBaseOpts(relevanceMatchId, BidsBaseSteps.OPTS_DELETED);
        runAndCheck(false);
    }

    @Test
    @Description("Проверка на отправку активного бесфразного таргетинга с ретаргетингом в новой ТГО группе (кампания " +
            "так же новая)")
    public void testAddingToBsQueueForRelevanceMatchAndRetargetingInNewGroup() {
        long retListId = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN).get(0);
        api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retListId);
        runAndCheck(true);
    }

    @Step("Вызов bsExportMaster.pl + bsClientData.pl и проверка отправки данных")
    private void runAndCheck(boolean expectRelevantMath) {
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        RelevanceMatch relevanceMatch = context != null ? context.getRelevanceMatch(relevanceMatchId) : null;
        Phrase phrase = context != null ? context.getPhrase(bidsId) : null;

        assertThat("Ожидаем, что в БК была отправлена новая кампания", campaign, notNullValue());
        assertThat("Ожидаем, что в БК была отправлена новая группа", context, notNullValue());
        assertThat("Ожидаем, что в БК был отправлен новый баннер", banner, notNullValue());
        assertThat("Ожидаем, что в БК была отправлена новая фраза", phrase, notNullValue());
        if (expectRelevantMath) {
            assertThat("Ожидаем, что в БК был отправлен бесфразный таргетинг", relevanceMatch, notNullValue());
        } else {
            assertThat("Ожидаем, что в БК не был отправлен бесфразный таргетинг", relevanceMatch, nullValue());
        }
    }
}
