package ru.yandex.autotests.directintapi.bstransport.main.relevancematch.actions.creation.transmit;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.BidsBaseSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.RelevanceMatch;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 14.03.17.
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Description("Транспорт: проверка отправки в БК объектов с бесфразным таргетингом для бесфразного таргетинга в группе" +
        " без фраз")
@Stories(StoriesNames.RELEVANCE_MATCH_ACTION)
@Features({FeatureNames.RELEVANCE_MATCH, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-63412")
public class BsTransportOfRelevanceMatchInGroupWithNoPhrasesTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long bid;
    private static Long pid;
    private static Long relevanceMatchId;

    private static Campaign campaign;
    private static Context context;
    private static RelevanceMatch relevanceMatch;
    private static Banner banner;
    private static List<Phrase> phrases;
    private static BidsBaseSteps bidsBaseSteps;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        bidsBaseSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsBaseSteps();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        relevanceMatchId = bidsBaseSteps.saveDefaultRelevanceMatch(cid, pid, Currency.RUB);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        phrases = getMapValues(context != null ? context.getPhrases() : null);
        relevanceMatch = context != null ? context.getRelevanceMatch(relevanceMatchId) : null;
    }


    @Test
    @Description("Отправка в БК бесфразного таргетинга в новой группе (кампания так же новая) " +
            "(группа без фраз) - проверка объекта Кампания")
    public void testTransportOfCampaignObjForRelevanceMatchInNewGroupWithNoPhrase() {
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaign, helpSteps.campaignReq1Matcher(cid, shard, false));
    }

    @Test
    @Description("Отправка в БК бесфразного таргетинга в новой группе (кампания так же новая) " +
            "(группа без фраз) - проверка объекта Контекст")
    public void testTransportOfContextObjForRelevanceMatchInNewGroupWithNoPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Description("Отправка в БК бесфразного таргетинга в новой группе (кампания так же новая) " +
            "(группа без фраз) - проверка объекта Баннер")
    public void testTransportOfBannerObjForRelevanceMatchInNewGroupWithNoPhrase() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Description("Отправка в БК бесфразного таргетинга в новой группе (кампания так же новая) " +
            "(группа без фраз) - проверка объекта Фраза")
    public void testTransportOfPhraseObjForRelevanceMatchInNewGroupWithNoPhrase() {
        assertThat("в БК не были отправлены фразы", phrases, empty());
    }

    @Test
    @Description("Отправка в БК бесфразного таргетинга в новой группе (кампания так же новая) " +
            "(группа без фраз) - проверка наличия бесфразного таргетинга")
    public void testTransportOfRelevanceMatchObjForRelevanceMatchInNewGroupWithNoPhrase() {
        assertThat("в БК отправился бесфразный таргетинг", relevanceMatch, notNullValue());
    }

    @Test
    @Description("Отправка в БК бесфразного таргетинга в новой группе (кампания так же новая) " +
            "(группа без фраз) - проверка синхронизации кампании после отправки")
    public void checkCamapignStatusBsSynced() {
        assertThat("кампания синхронизирована",
                api.userSteps.campaignFakeSteps().fakeGetCampaignParams(cid).getStatusBsSynced(),
                equalTo(Status.YES));
    }

    @Test
    @Description("Отправка в БК бесфразного таргетинга в новой группе (кампания так же новая) " +
            "(группа без фраз) - проверка синхронизации группы после отправки")
    public void checkGroupStatusBsSynced() {
        assertThat("группа синхронизирована",
                api.userSteps.groupFakeSteps().getGroupParams(pid).getStatusBsSynced(),
                equalTo(Status.YES));
    }

    @Test
    @Description("Отправка в БК бесфразного таргетинга в новой группе (кампания так же новая) " +
            "(группа без фраз) - проверка синхронизации баннера после отправки")
    public void checkBannerStatusBsSynced() {
        assertThat("баннер синхронизирован",
                api.userSteps.bannersFakeSteps().getBannerParams(bid).getStatusBsSynced(),
                equalTo(Status.YES));
    }
}
