package ru.yandex.autotests.directintapi.bstransport.main.relevancematch.parameters;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.BidsBaseSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.RelevanceMatch;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.AutoBudgetPriority.MEDIUM;
import static ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals.getRandom;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 17.03.17.
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Description("Транспорт: проверка отправки в БК приоритета автобюджета в бесфразном таргетинге")
@Features({FeatureNames.RELEVANCE_MATCH})
@Issue("https://st.yandex-team.ru/DIRECT-63412")
@RunWith(Parameterized.class)
public class RelevanceMatchAutobudgetPriorityTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private static BidsBaseSteps bidsBaseSteps;

    private RelevanceMatch relevanceMatch;
    private Long relevanceMatchId;

    @Parameterized.Parameter
    public TextCampaignSearchStrategyMap strategy;

    @Parameterized.Parameters(name = "стратегия в РСЯ = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB)},
                {new TextCampaignSearchStrategyMap().defaultAverageCpa(Currency.RUB, 0l)},
                {new TextCampaignSearchStrategyMap().defaultAverageCpc(Currency.RUB)},
                {new TextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(Currency.RUB, 0l)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        bidsBaseSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsBaseSteps();
    }

    @Before
    public void before() {
        long goalId = getRandom();

        api.userSteps.getDirectJooqDbSteps().useShard(shard);
        TextCampaignNetworkStrategyMap networkStrategy =
                new TextCampaignNetworkStrategyMap().defaultNetworkDefault();
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.getDirectJooqDbSteps().campMetrikaGoalsSteps().addOrUpdateMetrikaGoals(cid, goalId, 100L, 100L);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(strategy)
                                        .withNetwork(networkStrategy)))));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        relevanceMatchId =
                bidsBaseSteps.saveDefaultRelevanceMatch(cid, pid, Currency.RUB);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse
                resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        relevanceMatch = context != null ? context.getRelevanceMatch(relevanceMatchId) : null;

        assumeThat("в БК отправлен бесфразный таргетинг", relevanceMatch, notNullValue());
    }


    @Test
    public void testTransportOfDefaultPriorityForSearchStrategies() {
        RelevanceMatch expectedRelevanceMatch = new RelevanceMatch()
                .withEid(relevanceMatchId.toString())
                .withAutoBudgetPriority(MEDIUM.transportValue());
        assertThat("отправился правильный бесфразный таргетинг", relevanceMatch,
                beanDiffer(expectedRelevanceMatch).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
