package ru.yandex.autotests.directintapi.bstransport.main.relevancematch.parameters;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.BidsBaseSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.RelevanceMatch;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.db.steps.ClientsOptionsSteps.ClientFlagsEnum.FEATURE_CONTEXT_RELEVANCE_MATCH_ALLOWED;
import static ru.yandex.autotests.direct.db.steps.ClientsOptionsSteps.ClientFlagsEnum.FEATURE_CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY;
import static ru.yandex.autotests.direct.utils.features.FeatureNameEnum.CONTEXT_RELEVANCE_MATCH;
import static ru.yandex.autotests.direct.utils.features.FeatureNameEnum.CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 17.03.17.
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Description("Транспорт: проверка отправки в БК ставок в бесфразном таргетинге")
@Features({FeatureNames.RELEVANCE_MATCH})
@Issue("https://st.yandex-team.ru/DIRECT-63412")
@RunWith(Parameterized.class)
public class RelevanceMatchPricesTest {

    private static final String login = Logins.LOGIN_TRANSPORT_RM2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private static BidsBaseSteps bidsBaseSteps;
    private static final Money PRICE = MoneyCurrency.get(Currency.RUB).getMinPrice().multiply(5l);
    private static final Money PRICE_CONTEXT = MoneyCurrency.get(Currency.RUB).getMinPrice().multiply(4l);
    private static final TextCampaignSearchStrategyAddMap strategy =
            new TextCampaignSearchStrategyAddMap().defaultHighestPosition();
    private static long featureOneId;
    private static long featureTwoId;
    private static long clientId;
    private RelevanceMatch relevanceMatch;
    private Long relevanceMatchId;

    @Parameterized.Parameter(0)
    public boolean clientHasExtendedRelevanceMatch;

    @Parameterized.Parameter(1)
    public boolean extendedRelevanceMatchInterfaceOnly;

    @Parameterized.Parameter(2)
    public String relevanceMatchFlag;

    @Parameterized.Parameter(3)
    public String expectedRelevanceMatchType;

    @Parameterized.Parameters(name =
            "extendedRelevanceMatch = {0}, extendedRelevanceMatchInterfaceOnly = {1}, bid_base.options = {2}, expectedRelevanceMatchType = {3}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {false, false, BidsBaseSteps.OPTS_SEARCH_STOP, null},
                {false, false, BidsBaseSteps.OPTS_NET_STOP, null},
                {false, false, BidsBaseSteps.OPTS_DEFAULT, null},
                {false, true, BidsBaseSteps.OPTS_SEARCH_STOP, RelevanceMatch.TYPE_BOTH},
                {false, true, BidsBaseSteps.OPTS_NET_STOP, RelevanceMatch.TYPE_BOTH},
                {false, true, BidsBaseSteps.OPTS_DEFAULT, RelevanceMatch.TYPE_BOTH},
                {true, false, BidsBaseSteps.OPTS_SEARCH_STOP, RelevanceMatch.TYPE_BOTH},
                {true, false, BidsBaseSteps.OPTS_NET_STOP, RelevanceMatch.TYPE_BOTH},
                {true, false, BidsBaseSteps.OPTS_DEFAULT, RelevanceMatch.TYPE_BOTH}

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        bidsBaseSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsBaseSteps();
        featureOneId = api.userSteps.getDirectJooqDbSteps().featuresSteps()
                .getFeatureId(CONTEXT_RELEVANCE_MATCH.getValue());
        featureTwoId = api.userSteps.getDirectJooqDbSteps().featuresSteps()
                .getFeatureId(CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY.getValue());
        clientId = Long.valueOf(User.get(login).getClientID());
    }

    @Before
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaignWithSearchStrategy(strategy);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).clientsSteps()
                .setClientFeature(clientId, featureOneId, clientHasExtendedRelevanceMatch);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).clientsSteps()
                .setClientFeature(clientId, featureTwoId, extendedRelevanceMatchInterfaceOnly);
        if (clientHasExtendedRelevanceMatch) {
            api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps()
                    .setClientFlag(clientId, FEATURE_CONTEXT_RELEVANCE_MATCH_ALLOWED);
        } else {
            api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps()
                    .dropClientFlag(clientId, FEATURE_CONTEXT_RELEVANCE_MATCH_ALLOWED);
        }
        if (extendedRelevanceMatchInterfaceOnly) {
            api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps()
                    .setClientFlag(clientId, FEATURE_CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY);
        } else {
            api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps()
                    .dropClientFlag(clientId, FEATURE_CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY);
        }

        BigDecimal savedPriceContext = clientHasExtendedRelevanceMatch || extendedRelevanceMatchInterfaceOnly ?
                PRICE_CONTEXT.bigDecimalValue() : BigDecimal.valueOf(0);
        relevanceMatchId = bidsBaseSteps
                .saveDefaultRelevanceMatchWithPriceAndOpts(cid, pid, Currency.RUB,
                        PRICE.bigDecimalValue(), savedPriceContext, relevanceMatchFlag);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse
                resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        relevanceMatch = context != null ? context.getRelevanceMatch(relevanceMatchId) : null;

        assumeThat("в БК отправлен бесфразный таргетинг", relevanceMatch, notNullValue());
    }

    @Test
    public void checkPriceAndCurrencyISOCode() {
        Double expectedPriceContext = expectedRelevanceMatchType == null ? 0 :
                (clientHasExtendedRelevanceMatch || extendedRelevanceMatchInterfaceOnly ?
                    PRICE_CONTEXT.doubleValue() : MoneyCurrency.get(Currency.RUB).getMinPrice().doubleValue());
                RelevanceMatch expectedRelevanceMatch = new RelevanceMatch()
                .withEid(relevanceMatchId.toString())
                .withPrice(PRICE.doubleValue())
                .withPriceContext(expectedPriceContext)
                .withCurrencyIsoCode(Currency.RUB.getIsoCode())
                .withRelevanceMatchType(expectedRelevanceMatchType);
        assertThat("отправился правильный бесфразный таргетинг", relevanceMatch,
                beanDiffer(expectedRelevanceMatch).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
