package ru.yandex.autotests.directintapi.bstransport.main.retargeting.actions.creation.queue;

import java.util.List;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "нового условия ретаргетинга в составе синхронизированной группы")
@Stories(StoriesNames.RETARGETING_ACTION_CREATION)
@Features({FeatureNames.RETARGETINGS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewRetargetingInSyncedGroupTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private static DirectJooqDbSteps jooqDbSteps;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
    }

    @Test
    @Title("Добавление в очередь нового ретаргетинга в синхронизированной " +
            "группе с ретаргетингом (кампания так же новая)")
    public void testBsTransportForNewRetargetingInSyncedGroupWithRetargeting() {
        List<Long> retConditions = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN);
        Long retCondId1 = retConditions.get(0);
        Long retCondId2 = retConditions.get(1);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retCondId1);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retCondId2);

        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord bsExportQueueRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись для кампании с новым условием " +
                        "ретаргетинга (до этого в группе уже были условия ретаргетинга)",
                bsExportQueueRecord, new QueueRecordMatcher()
                        .withContexts()
                        .withBids()
                        .withoutBanners()
                        .withoutCamps()
                        .withoutPrices()
                        .withoutFullExport());

        checkStatusbssynced(cid, bid, pid);
    }

    @Test
    @Title("Добавление в очередь нового ретаргетинга и фразы в синхронизированной " +
            "группе с ретаргетингом и фразой (кампания так же новая)")
    public void testAddingToBsQueueForNewRetargetingsAndPhraseInSyncedGroupWithRetargetingAndPhrase() {
        List<Long> retConditions = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retConditions.get(0));

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retConditions.get(1));
        api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retConditions.get(2));

        long keywordIdElse = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordIdElse);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord bsExportQueueRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись для кампании с новыми условиями " +
                        "ретаргетинга и новой фразой (до этого в группе было условие ретаргетинга и фраза)",
                bsExportQueueRecord, new QueueRecordMatcher()
                        .withContexts()
                        .withBids()
                        .withoutBanners()
                        .withoutCamps()
                        .withoutPrices()
                        .withoutFullExport());

        checkStatusbssynced(cid, bid, pid);
    }

    private static void checkStatusbssynced(long cid, long bid, long pid) {
        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(cid);
        Assert.assertThat("Кампания клиента синхронизирована с БК",
                campaignsRecord.getStatusbssynced(), equalTo(CampaignsStatusbssynced.Yes));

        BannersRecord bannerRecord = jooqDbSteps.bannersSteps().getBanner(bid);
        Assert.assertThat("баннер синхронизирован с БК",
                bannerRecord.getStatusbssynced(), equalTo(BannersStatusbssynced.Yes));

        PhrasesRecord phrasesRecord = jooqDbSteps.adGroupsSteps().getPhrases(pid);
        Assert.assertThat("Статус группы не синхронизирован с БК",
                phrasesRecord.getStatusbssynced(), equalTo(PhrasesStatusbssynced.Sending));
    }
}
