package ru.yandex.autotests.directintapi.bstransport.main.retargeting.actions.creation.transmit;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нового ретаргетинга " +
        "в составе новой группы с фразой")
@Stories(StoriesNames.RETARGETING_ACTION_CREATION)
@Features({FeatureNames.RETARGETINGS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewRetargetingInNewGroupWithPhraseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long bid;
    private static Long pid;
    private static Long bidsId;
    private static Long retId;

    private static Context context;
    private static Phrase phrase;
    private static GoalContext goalContext;
    private static Banner banner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long retCondId = helpSteps.addRetargetingListsForUserIfNotExists(login).get(0);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
        retId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(login, pid, retCondId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        phrase = context != null ? context.getPhrase(bidsId) : null;
        goalContext = context != null ? context.getGoalContext(retId) : null;
    }

    @Test
    @Title("Отправка в БК нового ретаргетинга в новой группе (кампания так же новая) " +
            "(группа с фразой) - проверка объекта Контекст")
    public void testTransportOfContextObjForNewRetargetingInNewGroupWithPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нового ретаргетинга в новой группе (кампания так же новая) " +
            "(группа с фразой) - проверка объекта Баннер")
    public void testTransportOfBannerObjForNewRetargetingInNewGroupWithPhrase() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК нового ретаргетинга в новой группе (кампания так же новая) " +
            "(группа с фразой) - проверка объекта Фраза")
    public void testTransportOfPhraseObjForNewRetargetingInNewGroupWithPhrase() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        expectedPhrase.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                phrase, beanEquals(expectedPhrase));
    }

    @Test
    @Title("Отправка в БК нового ретаргетинга в новой группе (кампания так же новая) " +
            "(группа с фразой) - проверка объекта Ретаргетинг")
    public void testTransportOfGoalContextObjForNewRetargetingInNewGroupWithPhrase() {
        GoalContext expectedGoalContext = helpSteps.buildExpectedRetargetingObjFromDb(retId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового ретаргетинга соответствуют ожидаемым",
                goalContext, beanEquals(expectedGoalContext));
    }
}
