package ru.yandex.autotests.directintapi.bstransport.main.retargeting.actions.creation.transmit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.web.api.core.DirectRule;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pashkus on 22.06.15.
 * TESTIRT-5641
 * TESTIRT-9321
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК ретаргетинга " +
        "с условиями всех типов в составе новой группы с фразой")
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-37874"),
        @Issue("https://st.yandex-team.ru/DIRECT-52771")
})
@Stories(StoriesNames.RETARGETING_ACTION_CREATION)
@Features({FeatureNames.RETARGETINGS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewRetargetingWithAllGoalTypesInNewGroupWithPhrase {

    public static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static int shard;
    private static long retargetingCondId;
    private static Long bid;
    private static Long pid;
    private static Long bidsId;
    private static int retId;
    private static List<RetargetingGoal> goals = new ArrayList<>();
    private static Context context;
    private static Phrase phrase;
    private static GoalContext goalContext;
    private static Banner banner;
    @Rule
    public DirectRule directRule = DirectRule.defaultRule().as(LOGIN);
    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        //Создаем условие ретаргетинга состоящее из целей разных типов: сегментов метрики, сегментов аудитории и обычных
        List<RetargetingGoal> segmentGoals
                = api.userSteps.retargetingSteps().getRetargetingGoals(RetargetingGoalType.SEGMENT, LOGIN);
        List<RetargetingGoal> commonGoals
                = api.userSteps.retargetingSteps().getRetargetingGoals(RetargetingGoalType.GOAL, LOGIN);
        List<RetargetingGoal> audienceGoals
                = api.userSteps.retargetingSteps().getRetargetingGoals(RetargetingGoalType.AUDIENCE_SEGMENT, LOGIN);

        assumeThat("кол-во целей типа сегмент > 0", segmentGoals.size(), greaterThan(0));
        goals.add(segmentGoals.get(RandomUtils.getRandomInteger(0, segmentGoals.size() - 1)));
        assumeThat("кол-во целей типа сегмент аудитории > 0", audienceGoals.size(), greaterThan(0));
        goals.add(audienceGoals.get(RandomUtils.getRandomInteger(0, audienceGoals.size() - 1)));
        assumeThat("кол-во обычных целей > 0", commonGoals.size(), greaterThan(0));
        goals.add(commonGoals.get(RandomUtils.getRandomInteger(0, commonGoals.size() - 1)));

        long[] goalIds = goals.stream().mapToLong(RetargetingGoal::getGoalID).toArray();
        retargetingCondId = api.userSteps.retargetingListsSteps()
                .addRandomRetargetingList(LOGIN, goalIds);
        assumeThat("добавился ретаргетинг", retargetingCondId, notNullValue());

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        retId = api.userSteps.retargetingSteps().addRetargetingToBanner(LOGIN, bid, (int) retargetingCondId);

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        phrase = context != null ? context.getPhrase(bidsId) : null;
        goalContext = context != null ? context.getGoalContext((long) retId) : null;

    }

    @Before
    public void setUp() throws Exception {
        helpSteps.useDirectWebApiSteps(directRule.webApiSteps());
    }

    @Test
    @Title("Отправка в БК новой кампании с ретаргетингом из целей всех видов" +
            "(группа с фразой) - проверка объекта Context")
    public void testTransportOfContextObjForNewRetargetingWithBothGoalTypesInNewGroupWithPhrase() {

        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправляемые в БК данные нового объекта Context соответсвуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой кампании с ретаргетингом из целей всех видов " +
            "(группа с фразой) - проверка объекта Banner")
    public void testTransportOfBannerObjForNewRetargetingWithBothGoalTypesInNewGroupWithPhrase() {

        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправляемые в БК данные нового объекта Banner соответсвуют ожидаемым",
                banner, beanEquals(expectedBanner).ignoreFields("id"));
    }

    @Test
    @Title("Отправка в БК новой кампании с ретаргетингом из целей всех видов " +
            "(группа с фразой) - проверка объекта Phrase")
    public void testTransportOfPhraseObjForNewRetargetingWithBothGoalTypesInNewGroupWithPhrase() {

        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        assertThat("отправляемые в БК данные нового объекта Phrase соответсвуют ожидаемым",
                phrase, beanEquals(expectedPhrase).ignoreFields("id"));
    }

    @Test
    @Title("Отправка в БК новой кампании с ретаргетингом из целей всех видов " +
            "(группа с фразой) - проверка объекта Phrase")
    public void testTransportOfPhraseObjForNewRetargetingWithBothGoalTypesInNewGroupWithGoalContext() {

        GoalContext expectedGoalContext = helpSteps.buildExpectedRetargetingObjFromDb((long) retId, shard, UpdateInfo.UPDATE);
        assertThat("отправляемые в БК данные нового объекта Context соответсвуют ожидаемым",
                goalContext, beanEquals(expectedGoalContext));
    }

    @Test
    @Title("Отправка в БК новой кампании с ретаргетингом из целей всех видов " +
            "(группа с фразой) - проверка поля GoalContext.Expression")
    public void testTransportOfGoalContextObjForNewRetargetingWithBothGoalTypesInNewGroupWithPhrase() {
        List<String> expectedExpressionElements = helpSteps.getRetConditionsBSStyleElements(
                retargetingCondId);
        List<String> actualExpressionElements = Arrays.asList(goalContext.getExpression().split("[&|]"));
        Collections.sort(expectedExpressionElements);
        Collections.sort(actualExpressionElements);
        assertThat("отправляемые в БК данные нового поля GoalContext.Expression соответсвуют ожидаемым",
                actualExpressionElements, beanDiffer(expectedExpressionElements));
    }
}
