package ru.yandex.autotests.directintapi.bstransport.main.retargeting.actions.creation.transmit;

import java.util.Arrays;
import java.util.Collections;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.beans.retargeting.Goal;
import ru.yandex.autotests.direct.db.beans.retargeting.RetargetingConditionRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.CryptaGoalsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.web.api.core.DirectRule;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.Assert.assertNotNull;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК условия ретаргетинга с сегментами и хостами Крипы")
@Stories(StoriesNames.RETARGETING_ACTION_CREATION)
@Features({FeatureNames.RETARGETINGS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewRetargetingWithCustomAudienceTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final long INTEREST_GOAL_ID = 2499680002L;
    private static final long HOST_GOAL_ID = 19_000_000_000L;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public DirectRule directRule = DirectRule.defaultRule().as(LOGIN);
    @Rule
    public Trashman trasher = new Trashman(api);

    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private int shard;
    private DirectJooqDbSteps dbSteps;
    private Long clientId;

    @Before
    public void setUp() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
        helpSteps.useDirectWebApiSteps(directRule.webApiSteps());
    }

    @Test
    public void shouldSendExpressionWithAudienceAndHost() {
        long retCondId = createRetargetingCondition();
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);

        //send data
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        int retId = api.userSteps.retargetingSteps().addRetargetingToBanner(LOGIN, bid, (int) retCondId);
        GoalContext expectedGoalContext = helpSteps.buildExpectedRetargetingObjFromDb((long) retId, shard, UpdateInfo.UPDATE);
        expectedGoalContext.setExpression("(" + getExpressionForInterest() + "|" + HOST_GOAL_ID + ":540@1161)");

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        //check data
        Context context = api.userSteps.getDarkSideSteps().getTransportSteps().getBsClientDataContext(campaign, pid);
        assertNotNull(context);
        GoalContext goalContext = context.getGoalContext((long) retId);
        assertThat("отправленные в БК данные нового объекта GoalContext соответствуют ожидаемым",
                goalContext, beanEquals(expectedGoalContext));
    }

    /**
     * Creates retargeting condition via jooq, because we do not support custom audience in API yet
     */
    private Long createRetargetingCondition() {
        Goal interestGoal = new Goal()
                .withGoalId(INTEREST_GOAL_ID)
                .withTime(0L);
        Goal hostGoal = new Goal()
                .withGoalId(HOST_GOAL_ID)
                .withTime(0L);

        RetargetingConditionRule rule = new RetargetingConditionRule()
                .withType("or")
                .withInterestType("short-term")
                .withGoals(Arrays.asList(interestGoal, hostGoal));

        RetargetingConditionsRecord retargetingCondition = new RetargetingConditionsRecord();

        retargetingCondition.setClientid(clientId);
        retargetingCondition.setConditionName("CUSTOM AUDIENCE");
        retargetingCondition.setConditionJson(Collections.singletonList(rule.toString()).toString());
        retargetingCondition.setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.interests);
        return dbSteps.retargetingConditionSteps().addRetargetingCondition(retargetingCondition, clientId);
    }

    private String getExpressionForInterest() {
        CryptaGoalsRecord cryptaGoal = dbSteps.cryptaGoalsSteps().getCryptaGoalsRecords().stream()
                .filter(goal -> INTEREST_GOAL_ID == goal.getGoalId())
                .findFirst()
                .orElseThrow(() -> new IllegalStateException("Unable to find goal with id " + INTEREST_GOAL_ID));

        return cryptaGoal.getBbKeywordValueShort() +
                ":0@" +
                cryptaGoal.getBbKeywordShort();
    }
}
