package ru.yandex.autotests.directintapi.bstransport.main.retargeting.actions.creation.transmit;
import java.util.Arrays;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pashkus on 22.06.15.
 * TESTIRT-5641
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК ретаргетинга " +
        "с сегментами в составе новой группы с фразой")
@Issue("https://st.yandex-team.ru/DIRECT-37874")

@Stories(StoriesNames.RETARGETING_ACTION_CREATION)
@Features({FeatureNames.RETARGETINGS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewRetargetingWithSegmentsInNewGroupWithPhraseTest {

    public static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private static int[] allRetargetingCondIds;
    private static Long bid;
    private static Long pid;
    private static Long bidsId;
    private static int retId;


    private static Context context;
    private static Phrase phrase;
    private static GoalContext goalContext;
    private static Banner banner;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        List<RetargetingGoal> segmentGoals = api.userSteps.retargetingSteps().getRetargetingGoals(RetargetingGoalType.SEGMENT, login);
        RetargetingConditionMap retargetingConditions = api.userSteps.retargetingSteps().generateRandomRetargetingCondition(login,
                segmentGoals.toArray(new RetargetingGoal[0]));

        api.userSteps.retargetingSteps().addRetargetingConditions(retargetingConditions);

        allRetargetingCondIds = api.userSteps.retargetingSteps().getRetargetingConditions(login);
        Arrays.sort(allRetargetingCondIds);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        retId = api.userSteps.retargetingSteps().addRetargetingToBanner(login, bid
                , allRetargetingCondIds[allRetargetingCondIds.length - 1]);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        phrase = context != null ? context.getPhrase(bidsId) : null;
        goalContext = context != null ? context.getGoalContext((long) retId) : null;
    }

    @Test
    @Title("Отправка в БК новой кампании с ретаргетингом из сегментов " +
            "(группа с фразой) - проверка объекта Context")
    public void testTransportOfContextObjForNewRetargetingWithSegmentsInNewGroupWithPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправляемые в БК данные нового объекта Context соответсвуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой кампании с ретаргетингом из сегментов " +
            "(группа с фразой) - проверка объекта Banner")
    public void testTransportOfBannerObjForNewRetargetingWithSegmentsInNewGroupWithPhrase() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправляемые в БК данные нового объекта Banner соответсвуют ожидаемым",
                banner, beanEquals(expectedBanner).ignoreFields("id"));
    }

    @Test
    @Title("Отправка в БК новой кампании с ретаргетингом из сегментов " +
            "(группа с фразой) - проверка объекта Phrase")
    public void testTransportOfPhraseObjForNewRetargetingWithSegmentsInNewGroupWithPhrase() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        assertThat("отправляемые в БК данные нового объекта Phrase соответствуют ожиданиям",
                phrase, beanEquals(expectedPhrase).ignoreFields("id"));
    }

    @Test
    @Title("Отправка в БК новой кампании с ретаргетингом из сегментов " +
            "(группа с фразой) - проверка объекта GoalContext")
    public void testTransportOfGoalContextForNewRetargetingWithSegmentsInNewGroupWithPhrase() {
        GoalContext expectedGoalContext = helpSteps.buildExpectedRetargetingObjFromDb((long) retId, shard, UpdateInfo.UPDATE);
        assertThat("отправляемые в БК данные нового ретаргетинга соответствуют ожидаемым",
                goalContext, beanEquals(expectedGoalContext));
    }

}


