package ru.yandex.autotests.directintapi.bstransport.main.retargeting.actions.deletion;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК удаления ретаргетинга")
@Stories(StoriesNames.RETARGETING_ACTION_DELETION)
@Features({FeatureNames.RETARGETINGS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfDeletedRetargetingTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long bid;
    private static Long pid;
    private static Long bidsId;

    private static Context context;
    private static Phrase phrase;
    private static Map<String, GoalContext> goalContexts;
    private static Banner banner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long retCondId = helpSteps.addRetargetingListsForUserIfNotExists(login).get(0);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        Long audienceTargetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(login, pid, retCondId);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.audienceTargetsSteps().delete(audienceTargetId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        phrase = context != null ? context.getPhrase(bidsId) : null;
        goalContexts = context != null &&
                context.getGoalContexts() != null &&
                context.getGoalContexts().size() > 0 ?
                context.getGoalContexts() : null;
    }

    @Test
    @Title("Отправка в БК удаления ретаргетинга - проверка объекта Контекст")
    public void testTransmissionOfContextObjForNewRetargetingInNewGroupWithPhrase() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК удаления ретаргетинга - проверка объекта Баннер")
    public void testTransmissionOfBannerObjForNewRetargetingInNewGroupWithPhrase() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        expectedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК удаления ретаргетинга - проверка объекта Фраза")
    public void testTransmissionOfPhraseObjForNewRetargetingInNewGroupWithPhrase() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                phrase, beanEquals(expectedPhrase));
    }

    @Test
    @Title("Отправка в БК удаления ретаргетинга - проверка списка ретаргетингов")
    public void testTransmissionOfGoalContextListForNewRetargetingInNewGroupWithPhrase() {
        assertThat("отправленные в БК данные нового ретаргетинга соответствуют ожидаемым",
                goalContexts, nullValue());
    }
}
