package ru.yandex.autotests.directintapi.bstransport.main.retargeting.actions.update;

import java.util.List;

import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsResyncQueueRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 10.07.15.
 * https://st.yandex-team.ru/TESTIRT-6236
 */
@Aqua.Test
@Description("Проверка работы скрипта ppcCheckRetargetingGoals.pm - добавление записей в таблицу ppc.bs_resync_queue " +
        "в ситуации, когда скрипт выставляет is_accessible = 1")
@Stories(StoriesNames.RETARGETING_GOALS_UPDATE)
@Features(FeatureNames.RETARGETINGS)
public class PpcRetargetingCheckGoalsForAccessibleRetargetingTest {

    private static final String LOGIN = Logins.CHECK_GOALS_CLIENT5;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private int shard;
    private String clientId;
    private static Long cid;
    private static Long pid;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        clientId = api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID();

        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDs(LOGIN);
        assumeThat("у пользователя имеются цели", goalIds, not(empty()));
        long goalId = goalIds.get(0);
        Long retargetingConditionId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(
                (long) goalId, LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                .setIsAccessible(retargetingConditionId, goalId, 0);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
        api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retargetingConditionId);
    }

    @Test
    public void testRunPpcRetargetingCheckGoalsAndCheckBsResyncQueue() {
        api.userSteps.getDarkSideSteps().getRunScriptSteps().runPpcRetargetingCheckGoals(shard, clientId);
        BsResyncQueueRecord actual = api.userSteps.getDirectJooqDbSteps()
                .bsResyncQueueSteps()
                .getBsResyncQueueRecord(cid, pid, 0L);
        assertThat("в таблице ppc.bs_resync_queue добавилась верная запись", actual, notNullValue());
        assertThat("у записи на переотправку ожидаемое значение приоритета",
                actual.getPriority(), Matchers.equalTo(90));
    }
}
