package ru.yandex.autotests.directintapi.bstransport.main.retargeting.actions.update;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsResyncQueueRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum.ALL;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 10.07.15.
 * https://st.yandex-team.ru/TESTIRT-6236
 */
@Aqua.Test
@Description("Проверка работы скрипта ppcCheckRetargetingGoals.pm для корректировок по ретагетингу" +
        "- добавление записей в таблицу ppc.bs_resync_queue в ситуации, когда скрипт выставляет is_accessible = 1")
@Stories(StoriesNames.RETARGETING_GOALS_UPDATE)
@Features({FeatureNames.RETARGETINGS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class PpcRetargetingCheckGoalsForInaccessibleRetargetingCoefTest {

    //TODO:new login
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final long INACCESSIBLE_GOAL_ID = 1685494L;
    /**
     * ACCESSIBLE_GOAL_ID не должен использоваться ни в одном другом тесте,
     * т. к. с ним будут проводиться нестандартные действия
     */
    private static final long ACCESSIBLE_GOAL_ID = 19990455L;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private int shard;
    private String clientId;
    private long initialGoalId = 0;
    private Long retargetingConditionId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        clientId = api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID();
    }

    @Test
    public void testRunPpcRetargetingCoefOnGroupCheckGoalsAndCheckBsResyncQueue() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        retargetingConditionId = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN).get(3);
        RetargetingListGetItem retargetingListGetItem
                = api.userSteps.retargetingListsSteps().get(retargetingConditionId).get(0);
        initialGoalId = retargetingListGetItem.getRules().get(0).getArguments().get(0).getExternalId();
        api.userSteps.retargetingListsSteps().update(new UpdateRequestMap()
                .withRetargetingLists(new RetargetingListUpdateItemMap()
                        .withId(retargetingConditionId)
                        .withRules(new RetargetingListRuleItemMap()
                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                        .withExternalId(ACCESSIBLE_GOAL_ID)
                                        .withMembershipLifeSpan(90))
                                .withOperator(ALL))));


        api.userSteps.getDirectJooqDbSteps().useShard(shard);
        api.userSteps.getDirectJooqDbSteps().retargetingGoalsSteps().substititeGoalId(retargetingConditionId,
                ACCESSIBLE_GOAL_ID, INACCESSIBLE_GOAL_ID);
        api.userSteps.getDirectJooqDbSteps().retargetingGoalsSteps()
                .setIsAccessible(retargetingConditionId, INACCESSIBLE_GOAL_ID, 1);

        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withAdGroupId(pid)
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(retargetingConditionId)
                                .withBidModifier(150)
                        )
        );

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        api.userSteps.getDarkSideSteps().getRunScriptSteps().runPpcRetargetingCheckGoals(shard, clientId);

        BsResyncQueueRecord actual = api.userSteps.getDirectJooqDbSteps()
                .bsResyncQueueSteps()
                .getBsResyncQueueRecord(cid, pid, 0L);
        assertThat("в таблице ppc.bs_resync_queue добавилась запись", actual, not(nullValue()));
        assertThat("запись в таблице ppc.bs_resync_queue имеет верный приоритет",
                actual.getPriority(), equalTo(90));
    }

    @Test
    public void testRunPpcRetargetingCoefOnCampaignCheckGoalsAndCheckBsResyncQueue() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        retargetingConditionId = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN).get(3);
        RetargetingListGetItem retargetingListGetItem
                = api.userSteps.retargetingListsSteps().get(retargetingConditionId).get(0);
        initialGoalId = retargetingListGetItem.getRules().get(0).getArguments().get(0).getExternalId();
        api.userSteps.retargetingListsSteps().update(new UpdateRequestMap()
                .withRetargetingLists(new RetargetingListUpdateItemMap()
                        .withId(retargetingConditionId)
                        .withRules(new RetargetingListRuleItemMap()
                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                        .withExternalId(ACCESSIBLE_GOAL_ID)
                                        .withMembershipLifeSpan(90))
                                .withOperator(ALL))));

        api.userSteps.getDirectJooqDbSteps().useShard(shard);
        api.userSteps.getDirectJooqDbSteps().retargetingGoalsSteps().substititeGoalId(retargetingConditionId,
                ACCESSIBLE_GOAL_ID, INACCESSIBLE_GOAL_ID);
        api.userSteps.getDirectJooqDbSteps().retargetingGoalsSteps()
                .setIsAccessible(retargetingConditionId, INACCESSIBLE_GOAL_ID, 1);

        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withCampaignId(cid)
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(retargetingConditionId)
                                .withBidModifier(150)
                        )
        );

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        api.userSteps.getDarkSideSteps().getRunScriptSteps().runPpcRetargetingCheckGoals(shard, clientId);

        BsResyncQueueRecord actual = api.userSteps.getDirectJooqDbSteps()
                .bsResyncQueueSteps()
                .getBsResyncQueueRecord(cid, 0L, 0L);
        assertThat("в таблице ppc.bs_resync_queue добавилась запись", actual, not(nullValue()));
        assertThat("запись в таблице ppc.bs_resync_queue имеет верный приоритет",
                actual.getPriority(), equalTo(90));
    }

    @After
    public void after() {
        if (initialGoalId != 0) {
            // возвращаем состояние в базе обратно как было
            api.userSteps.getDirectJooqDbSteps().retargetingGoalsSteps().substititeGoalId(retargetingConditionId,
                    INACCESSIBLE_GOAL_ID, initialGoalId);
            api.userSteps.getDirectJooqDbSteps().retargetingGoalsSteps()
                    .setIsAccessible(retargetingConditionId, initialGoalId, 1);
            api.userSteps.retargetingListsSteps().update(new UpdateRequestMap()
                    .withRetargetingLists(new RetargetingListUpdateItemMap()
                            .withId(retargetingConditionId)
                            .withRules(new RetargetingListRuleItemMap()
                                    .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                            .withExternalId(initialGoalId)
                                            .withMembershipLifeSpan(90))
                                    .withOperator(ALL))));
        }
    }
}
