package ru.yandex.autotests.directintapi.bstransport.main.retargeting.actions.update;

import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsResyncQueueRecord;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 10.07.15.
 * https://st.yandex-team.ru/TESTIRT-6236
 */
@Aqua.Test
@Description("Проверка работы скрипта ppcCheckRetargetingGoals.pm - добавление записей в таблицу ppc.bs_resync_queue " +
        "в ситуации, когда скрипт выставляет занчение isAccessible = 0")
@Stories(StoriesNames.RETARGETING_GOALS_UPDATE)
@Features({FeatureNames.RETARGETINGS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class PpcRetargetingCheckGoalsForInaccessibleRetargetingTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    /**
     * ACCESSIBLE_GOAL_ID не должен использоваться ни в одном другом тесте,
     * т. к. с ним будут проводиться нестандартные действия
     */
    private static final long ACCESSIBLE_GOAL_ID = 11732581L;
    private static final long INACCESSIBLE_GOAL_ID = 12113298L;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private int shard;
    private String clientId;
    private Long cid;
    private Long pid;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        clientId = api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID();

        Long retargetingConditionId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(
                ACCESSIBLE_GOAL_ID, LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);
        api.userSteps.getDirectJooqDbSteps().retargetingGoalsSteps().substititeGoalId(retargetingConditionId,
                ACCESSIBLE_GOAL_ID, INACCESSIBLE_GOAL_ID);
        api.userSteps.getDirectJooqDbSteps().retargetingGoalsSteps()
                .setIsAccessible(retargetingConditionId, INACCESSIBLE_GOAL_ID, 1);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);

        api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retargetingConditionId);
    }

    @Test
    public void testRunPpcRetargetingCheckGoalsAndCheckBsResyncQueue() {
        api.userSteps.getDarkSideSteps().getRunScriptSteps().runPpcRetargetingCheckGoals(shard, clientId);

        BsResyncQueueRecord actual = api.userSteps.getDirectJooqDbSteps()
                .bsResyncQueueSteps()
                .getBsResyncQueueRecord(cid, pid, 0L);
        assertThat("в таблице ppc.bs_resync_queue добавилась верная запись", actual, notNullValue());
        assertThat("у записи на переотправку ожидаемое значение приоритета",
                actual.getPriority(), Matchers.equalTo(90));
    }
}
