package ru.yandex.autotests.directintapi.bstransport.main.retargeting.parameters.bid;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК ставки в РСЯ " +
        "для нового ретаргетинга в новой группе")
@Stories(StoriesNames.RETARGETING_PARAMS_BID)
@Features(FeatureNames.RETARGETINGS)
public class BsTransportOfRetBidForNewRetInNewGroupTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private static final Money RET_PRICE = Money.valueOf(43.0f);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }


    @Test
    @Title("Отправка в БК ставки в РСЯ для нового ретаргетинга в новой группе")
    public void testTransportOfRetBidForNewRetInNewGroup() {
        Long retCondId = helpSteps.addRetargetingListsForUserIfNotExists(login).get(0);
        TextCampaignSearchStrategyAddMap searchStrategy =
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition();
        TextCampaignNetworkStrategyAddMap networkStrategy =
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage();
        Long cid =
                api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(searchStrategy, networkStrategy);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
        Long retId = api.userSteps.audienceTargetsSteps().add(login, new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retCondId)
                        .withContextBid(RET_PRICE.bidLong().longValue()))).get(0);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        GoalContext goalContext = context != null ? context.getGoalContext(retId) : null;

        assumeThat("в БК отправлен ретаргетинг", goalContext, notNullValue());

        assertThat("отправленная в БК ставка в РСЯ для ретаргетинга соответствует ожидаемой",
                goalContext.getPriceContext(), equalTo(RET_PRICE.doubleValue()));
    }
}
