package ru.yandex.autotests.directintapi.bstransport.matchers.flags;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

/**
 * Матчер поля Age на уровне баннера. Значение поля в транспорте
 * зависит от значения поля в БД ppc:banners.flags, которое
 * содержит флаги модерации через запятую. Когда среди флагов
 * модерации присутствует флаг "age:[число]", то в поле Age
 * отправляется "[число]+" (при этом в поле Flags на уровне
 * баннера вместо флага "age:[число]" подставляется "plus18").
 */
public class AgeMatcher extends BaseMatcher<String> {

    /**
     * @param dbFlags значение поля в БД ppc:banners.flags
     * @return матчер для поля Age на уровне баннера
     */
    public static AgeMatcher transportAgeCompliesWithDb(String dbFlags) {
        return new AgeMatcher(dbFlags);
    }

    private static final Pattern AGE_PATTERN = Pattern.compile("age:\\d+");

    private String expectedAge;

    private AgeMatcher(String dbFlags) {
        if (dbFlags == null) {
            return;
        }
        List<String> dbFlagsList = new ArrayList<>(Arrays.asList(dbFlags.split(",")));
        for (String dbFlag : dbFlagsList) {
            if (AGE_PATTERN.matcher(dbFlag).matches()) {
                expectedAge = dbFlag.split(":")[1] + "+";
            }
        }
    }

    @Override
    public boolean matches(Object transportAge) {
        return expectedAge == null ? (transportAge == null) : expectedAge.equals(transportAge);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("" + expectedAge);
    }
}
