package ru.yandex.autotests.directintapi.bstransport.matchers.flags;

import ru.yandex.autotests.irt.testutils.beandiffer2.Diff;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.AbstractDiffer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static ru.yandex.autotests.directintapi.bstransport.matchers.flags.FlagsMatcher.transportFlagsCompliesWithDb;

/**
 * Differ поля Flags на уровне баннера. Значение поля в транспорте
 * зависит от значения поля в БД ppc:banners.flags, которое
 * содержит флаги модерации через запятую. Значение поля Flags
 * представляет собой перечисление тех же флагов модерации из БД
 * через запятую без сохранения порядка и с некоторыми исключениями:
 * 1. когда среди флагов модерации присутствует флаг "age:[число]",
 * то в поле Flags вместо него подставляется флаг "plus18"
 * (а в поле Age отправляется возрастная метка в виде "[число]+");
 * 2. когда среди флагов модерации присутствует флаг "baby_food:[число]",
 * то в поле Flags вместо него подставляется флаг "baby_food_[число]".
 */
public class FlagsDiffer extends AbstractDiffer {

    @Override
    public List<Diff> compare(Object actual, Object expected) {
        boolean isEquals = false;
        if (actual instanceof String) {
            if (expected instanceof String) {
                isEquals = transportFlagsCompliesWithDb((String) expected).matchesSafely((String) actual);
            }
        }
        if (!isEquals) {
            return Arrays.asList(Diff.changed(getField(), actual, expected));
        }
        return new ArrayList<>();
    }
}
