package ru.yandex.autotests.directintapi.bstransport.matchers.images;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.beans.images.ImageFormat;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Image;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Images;

import static org.hamcrest.Matchers.*;

public class BannerWideImagesMatcher extends BaseMatcher<Images> {

    private static final String URL_BEGIN = "//";

    public static BannerWideImagesMatcher isValid() {
        return new BannerWideImagesMatcher();
    }

    private Matcher<Images> matcher = buildImagesMatcher();

    private BannerWideImagesMatcher() {
    }


    @Override
    public boolean matches(Object images) {
        return matcher.matches(images);
    }

    @Override
    public void describeTo(Description description) {
        matcher.describeTo(description);
    }

    @Override
    public void describeMismatch(Object item, Description description) {
        matcher.describeMismatch(item, description);
    }

    //16:9 format
    private static Matcher<Images> buildImagesMatcher() {
        Images images = new Images();

        BeanEquals<Image> matcherWx150 = BeanEquals.beanEquals(
                new Image().withWidth(Integer.parseInt(ImageFormat.WX_150.getWidth()))
        ).accordingStrategy(
                new BeanCompareStrategy()
                        .putFieldMatcher(Image.URL.toLowerCase(), startsWith(URL_BEGIN))
                        .putFieldMatcher(Image.HEIGHT, greaterThan(0))
        );
        BeanEquals<Image> matcherWx300 = BeanEquals.beanEquals(
                new Image().withWidth(Integer.parseInt(ImageFormat.WX_300.getWidth()))
        ).accordingStrategy(
                new BeanCompareStrategy()
                        .putFieldMatcher(Image.URL.toLowerCase(), startsWith(URL_BEGIN))
                        .putFieldMatcher(Image.HEIGHT, greaterThan(0))
        );
        BeanEquals<Image> matcherWx600 = BeanEquals.beanEquals(
                new Image().withWidth(Integer.parseInt(ImageFormat.WX_600.getWidth()))
        ).accordingStrategy(
                new BeanCompareStrategy()
                        .putFieldMatcher(Image.URL.toLowerCase(), startsWith(URL_BEGIN))
                        .putFieldMatcher(Image.HEIGHT, greaterThan(0))
        );
        BeanEquals<Image> matcherWx1080 = BeanEquals.beanEquals(
                new Image().withWidth(Integer.parseInt(ImageFormat.WX_1080.getWidth()))
        ).accordingStrategy(
                new BeanCompareStrategy()
                        .putFieldMatcher(Image.URL.toLowerCase(), startsWith(URL_BEGIN))
                        .putFieldMatcher(Image.HEIGHT, greaterThan(0))
        );
        BeanEquals<Image> matcherWy150 = BeanEquals.beanEquals(
                new Image().withHeight(Integer.parseInt(ImageFormat.WY_150.getHeight()))
        ).accordingStrategy(
                new BeanCompareStrategy()
                        .putFieldMatcher(Image.URL.toLowerCase(), startsWith(URL_BEGIN))
                        .putFieldMatcher(Image.WIDTH, greaterThan(0))
        );
        BeanEquals<Image> matcherWy300 = BeanEquals.beanEquals(
                new Image().withHeight(Integer.parseInt(ImageFormat.WY_300.getHeight()))
        ).accordingStrategy(
                new BeanCompareStrategy()
                        .putFieldMatcher(Image.URL.toLowerCase(), startsWith(URL_BEGIN))
                        .putFieldMatcher(Image.WIDTH, greaterThan(0))
        );

        BeanCompareStrategy strategy = new BeanCompareStrategy();
        strategy.putFieldMatcher("wx150", matcherWx150);
        strategy.putFieldMatcher("wx300", matcherWx300);
        strategy.putFieldMatcher("wx600", matcherWx600);
        strategy.putFieldMatcher("wx1080", matcherWx1080);
        strategy.putFieldMatcher("wy150", matcherWy150);
        strategy.putFieldMatcher("wy300", matcherWy300);
        // small/regular formats
        strategy.putFieldMatcher("x80", nullValue());
        strategy.putFieldMatcher("x90", nullValue());
        strategy.putFieldMatcher("x150", nullValue());
        strategy.putFieldMatcher("x160", nullValue());
        strategy.putFieldMatcher("x180", nullValue());
        strategy.putFieldMatcher("x300", nullValue());
        strategy.putFieldMatcher("x450", nullValue());
        strategy.putFieldMatcher("y65", nullValue());
        strategy.putFieldMatcher("y80", nullValue());
        strategy.putFieldMatcher("y90", nullValue());
        strategy.putFieldMatcher("y110", nullValue());
        strategy.putFieldMatcher("y129", nullValue());
        strategy.putFieldMatcher("y150", nullValue());
        strategy.putFieldMatcher("y160", nullValue());
        strategy.putFieldMatcher("y180", nullValue());
        strategy.putFieldMatcher("y300", nullValue());
        strategy.putFieldMatcher("y450", nullValue());

        return BeanEquals
                .beanEquals(images)
                .accordingStrategy(strategy);
    }

}
