package ru.yandex.autotests.directintapi.bstransport.matchers.timetarget;

import com.yandex.direct.api.v5.campaigns.TimeTargetingAdd;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import ru.yandex.autotests.directapi.common.api45.TimeTargetInfo;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.List;

public class TimeTargetMatcher extends BaseMatcher<List<String>> {

    public static TimeTargetMatcher targetTimeEquals(List<String> timeTarget) {
        return new TimeTargetMatcher(timeTarget);
    }

    public static TimeTargetMatcher targetTimeEquals(TimeTargetInfo timeTargetInfo) {
        return targetTimeEquals(TimeTargetUtils.timeTargetToTransportFormat(timeTargetInfo));
    }

    public static TimeTargetMatcher targetTimeEquals(TimeTargetingAdd timeTargetingAdd) {
        return targetTimeEquals(TimeTargetUtils.timeTargetingAddToTransportFormat(timeTargetingAdd));
    }

    private List<String> etalon;

    private TimeTargetMatcher(List<String> etalon) {
        this.etalon = etalon;
    }

    @Override
    @SuppressWarnings("unchecked")
    public boolean matches(Object item) {
        return checkType(item) && TimeTargetUtils.targetTimeEquals(etalon, (List<String>) item);
    }

    @Override
    @SuppressWarnings("unchecked")
    public void describeMismatch(Object item, Description description) {
        if (!checkType(item)) {
            description.appendText("was a ")
                    .appendText(item.getClass().getName())
                    .appendText(" (")
                    .appendValue(item)
                    .appendText(")");
        } else {
            super.describeMismatch(item, description);
        }
    }

    public void describeTo(Description description) {
        description.appendText("equal to time target " + JsonUtils.toStringLow(etalon));
    }

    private boolean checkType(Object item) {
        try {
            List<String> typed = (List<String>) item;
            return true;
        } catch (ClassCastException e) {
            return false;
        }
    }
}
