package ru.yandex.autotests.directintapi.bstransport.savestate;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import org.junit.rules.TestWatcher;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.irt.restheart.client.RestheartHttpClient;
import ru.yandex.autotests.irt.restheart.config.ListOfBeans;
import ru.yandex.autotests.irt.restheart.config.MongoDatabases;
import ru.yandex.autotests.irt.testutils.TestUtilsException;

import static org.reflections.ReflectionUtils.getAllFields;
import static org.reflections.ReflectionUtils.withAnnotation;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
class StateBaseRule<T extends IState> extends TestWatcher {
    //todo может быть использовать другую базу
    private RestheartHttpClient mongoClient = new RestheartHttpClient()
            .useDB(MongoDatabases.DIRECT_HANDLES.getDbName())
            .useCollection("ObjectStates");
    private static Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    public static final String KEY = "stateKey";

    protected T object;
    protected Class<T> objectClass;

    public StateBaseRule(T object) {
        this.object = object;
        this.objectClass = (Class<T>) object.getClass();
    }

    private String getQuery() {
        return "{" + KEY + ":'" + object.getStateKey() + "'}";
    }

    private List<T> fromJsonList(String json) {
        return GSON.fromJson(json, new ListOfBeans<>(objectClass));
    }

    protected void saveState() throws UnsupportedEncodingException {
        JsonObject element = GSON.toJsonTree(object).getAsJsonObject();
        element.addProperty(KEY, object.getStateKey());
        element.addProperty("dstHost", DirectTestRunProperties.getInstance().getYabsAuditHost());
        element.addProperty("stageType", DirectTestRunProperties.getInstance().getDirectHost());
        element.addProperty("timestamp", LocalDateTime.now().toString());
        mongoClient.delete(getQuery());
        mongoClient.add(element.toString());
    }

    protected void loadState() throws UnsupportedEncodingException {
        String result = GSON.toJson(mongoClient.get(getQuery()).getResultDocuments());
        List<T> lst = fromJsonList(result);
        if (lst.size() == 0) {
            return;
        }
        T savedState = lst.get(0);
        for (Field field : getAllFields(objectClass, withAnnotation(Expose.class))) {
            try {
                field.set(object, field.get(savedState));
            } catch (IllegalAccessException e) {
                throw new TestUtilsException(e);
            }
        }
    }
}
