package ru.yandex.autotests.directintapi.bstransport.smoke;

import java.util.Arrays;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesCreativeType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.lessThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title("Проверка количества объектов у тестовых пользователей")
@Description("Тест для светофора ТС. Если тестовый клиент упирается в предельное количество кампаний, " +
        "креативов и т. п., то тесты в регресии начинают падать с соответветствующей ошибкой. Перед запуском " +
        "регресии нужно убедиться, в том, что лимит на добавление кампаний не исчерпан")
@Issue("https://st.yandex-team.ru/DIRECT-105535, https://st.yandex-team.ru/DIRECT-105985")
@RunWith(Parameterized.class)
public class UserObjectsCountTest {
    private static final Long CAMPS_COUNT_LIMIT = 150L;
    private static final Long PERF_CREATIVES_COUNT_LIMIT = 700L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String login;

    @Parameterized.Parameters(name = "login = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.LOGIN_TRANSPORT},
                {Logins.LOGIN_MAIN},
                {"at-direct-backend-c"},
                {"at-direct-backend-b"},
        });
    }

    @Test
    @Title("Проверка количества кампаний у тестового пользователя")
    public void testUserCampaignsCount() {
        Long uid = Long.valueOf(User.get(login).getPassportUID());
        int count = api.userSteps.getDirectJooqDbSteps().useShardForLogin(login).campaignsSteps()
                .getNotEmptyCampaignsByUid(uid).size();
        assertThat("максимально допустимое количество кампаний у " + login, Long.valueOf(count),
                lessThan(CAMPS_COUNT_LIMIT));
    }

    @Test
    @Title("Проверка количества креативов у тестового пользователя")
    public void testUserPerfCreativesCount() {
        Long clientid = Long.valueOf(User.get(login).getClientID());
        int count = api.userSteps.getDirectJooqDbSteps().useShardForLogin(login).perfCreativesSteps()
                .getPerfCreativesByClientId(clientid, PerfCreativesCreativeType.performance).size();
        assertThat("максимально допустимое количество креативов у " + login, Long.valueOf(count),
                lessThan(PERF_CREATIVES_COUNT_LIMIT));
    }
}
