package ru.yandex.autotests.direct.commander;

import org.apache.tika.mime.MimeTypes;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.events.MakeAttachmentEvent;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;

/**
 * Created by alexey-n on 10.12.14.
 */
public class AttachmentHelper {

    private Allure lifecycle;

    AttachmentHelper(Allure allureLifecycle) {
        lifecycle = allureLifecycle;
    }

    public void text(String text, String title) {
        attachStringDataEvent(text, title, "text/plain");
    }

    public void image(String filename, String title) throws IOException {
        Path path = FileSystems.getDefault().getPath(filename);
        byte [] fileData = Files.readAllBytes(path);
        MakeAttachmentEvent event = new MakeAttachmentEvent(fileData, title, "image/png");
        lifecycle.fire(event);
    }

    public void zip(String filename, String title) throws IOException {
        Path path = FileSystems.getDefault().getPath(filename);
        byte [] fileData = Files.readAllBytes(path);
        MakeAttachmentEvent event = new MakeAttachmentEvent(fileData, title, "application/zip");
        lifecycle.fire(event);
    }

    public void html(String html, String title) {
        attachStringDataEvent(html, title, "text/html");
    }

    public void json(String json, String title) {
        attachStringDataEvent(json, title, "application/json");
    }

    private void attachStringDataEvent(String text, String title, String mimeType) {
        MakeAttachmentEvent event = new MakeAttachmentEvent(text.getBytes(Charset.forName("UTF-8")), title, mimeType);
        lifecycle.fire(event);
    }
}
