package ru.yandex.autotests.direct.commander;

import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.events.*;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.LabelName;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static ru.yandex.autotests.direct.commander.utils.CommonUtils.getDecription;

/**
 * Created by alexey-n on 10.12.14.
 */
public class CaseHelper {

    private Allure lifecycle;

    CaseHelper(Allure allureLifecycle) {
        lifecycle = allureLifecycle;
    }

    public void start(String suiteUid, String testCaseName, String testCaseTitle,
                                                String descriptionText, String story, String feature, String host,
                                                String issue) {
        TestCaseStartedEvent event = new TestCaseStartedEvent(suiteUid, testCaseName);
        List<Label> labelList = new ArrayList<Label>();
        if (!"".equals(testCaseTitle)) {
            event.withTitle(testCaseTitle);
        }

        if (!"".equals(descriptionText)) {
            event.withDescription(getDecription(descriptionText));
        }

        if (!"".equals(story)) {
            labelList.add(new Label().withName(LabelName.STORY.value()).withValue(story));
        }

        if (!"".equals(feature)) {
            labelList.add(new Label().withName(LabelName.FEATURE.value()).withValue(feature));
        }

        if (!"".equals(host)) {
            labelList.add(new Label().withName(LabelName.HOST.value()).withValue(host));
        }
        if (!"".equals(host)) {
            labelList.add(new Label().withName(LabelName.ISSUE.value()).withValue(issue));
        }

        if (labelList.size() == 1) {
            event.withLabels(labelList.get(0));
        }
        if (labelList.size() > 1) {
            Label label = labelList.get(0);
            labelList.remove(0);
            event.withLabels(label, labelList.toArray(new Label[]{}));
        }
        lifecycle.fire(event);
        StepHelper.init();
    }

    public void start(String testCaseName, String testCaseTitle,
                      String descriptionText, String story, String feature, String host, String issue) {
        start(AllureHelper.currentSuiteUid, testCaseName, testCaseTitle, descriptionText,
                story, feature, host, issue);
    }

    public void start(String testCaseName, String testCaseTitle,
                       String descriptionText, String story, String feature, String host) {
        start(testCaseName, testCaseTitle, descriptionText,
                story, feature, host, "");
    }

    public void start(String testCaseName, String testCaseTitle,
                      String descriptionText, String story, String feature) {
        start(testCaseName, testCaseTitle, descriptionText,
                story, feature, "");
    }

    public void start(String testCaseName, String testCaseTitle,
                      String descriptionText, String story) {
        start(testCaseName, testCaseTitle, descriptionText,
                story, "");
    }

    public void start(String testCaseName, String testCaseTitle,
                      String descriptionText) {
        start(testCaseName, testCaseTitle, descriptionText, "");
    }

    public void start(String testCaseName, String testCaseTitle) {
        start(testCaseName, testCaseTitle, "");
    }

    public void start(String testCaseName) {
        start(testCaseName, "");
    }

    public void finish() {
        lifecycle.fire(new TestCaseFinishedEvent());
    }

    public void cancel(String message) {
        TestCaseCanceledEvent event = new TestCaseCanceledEvent();
        event.withThrowable(new Throwable(message));
        lifecycle.fire(event);
    }

    public void broken(String message) {
        TestCaseFailureEvent event = new TestCaseFailureEvent();
        event.withThrowable(new Throwable(message));
        lifecycle.fire(event);
    }

    public void failed(String message) {
        TestCaseFailureEvent event = new TestCaseFailureEvent();
        event.withThrowable(new AssertionError(message));
        lifecycle.fire(event);
    }

    public void pending(String message) {
        TestCasePendingEvent event = new TestCasePendingEvent();
        event.withMessage(message);
        lifecycle.fire(event);
    }
}
