package ru.yandex.autotests.direct.commander;

import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.events.TestCaseFinishedEvent;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteFinishedEvent;
import ru.yandex.qatools.allure.events.TestSuiteStartedEvent;
import ru.yandex.qatools.allure.model.Label;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

import static ru.yandex.autotests.direct.commander.utils.CommonUtils.getDecription;

/**
 * Created by alexey-n on 10.12.14.
 */
public class SuiteHelper {

    static List<String> SUITES = new LinkedList<String>();
    private Allure lifecycle;

    SuiteHelper(Allure allureLifecycle) {
        lifecycle = allureLifecycle;
    }

    public String start(String testSuiteName) {
        return start(testSuiteName, "");
    }

    public String start(String testSuiteName, String testTitle) {
        return start(testSuiteName, testTitle, "");
    }

    public String start(String testSuiteName, String testTitle, String descriptionText) {
        String uid = generateUUID();
        TestSuiteStartedEvent event = new TestSuiteStartedEvent(uid, testSuiteName);
        if (!"".equals(testTitle)) {
            event.withTitle(testTitle);
        }

        if (!"".equals(descriptionText)) {
            event.withDescription(getDecription(descriptionText));
        }

        lifecycle.fire(event);
        AllureHelper.currentSuiteUid = uid;
        return uid;
    }

    public void finish(String uid) {
        lifecycle.fire(new TestSuiteFinishedEvent(uid));
    }

    public void finish() {
        finish(AllureHelper.currentSuiteUid);
    }

    private String generateUUID() {
        String uid = null;
        do {
            uid = UUID.randomUUID().toString();
        } while (SUITES.contains(uid));
        SUITES.add(uid);

        return uid;
    }
}
