package ru.yandex.autotests.directapi.darkside;

import java.util.HashMap;

import ru.yandex.autotests.directapi.darkside.model.Role;

/**
 * Created by omaz on 21.02.14.
 * Логины для тестов
 */
public abstract class Logins {

    public static final String LOGIN_MAIN = "at-intapi-test";
    public static final String LOGIN_MAIN_REP = "at-intapi-test-rep";
    public static final String LOGIN_MAIN_IMAGES = "at-intapi-images";
    public static final String LOGIN_TRANSPORT = "at-transport-tester-7";
    public static final String LOGIN_TRANSPORT_FEATURES = "at-transport-tester-1";
    public static final String LOGIN_TRANSPORT_STATUSYANDEXADV = "at-transport-tester-3";   // меняет TargetType во ВСЕХ кампаниям на логине (и ломает другие тесты)
    public static final String LOGIN_TRANSPORT_IMG_WIDE = "at-direct-bs-wide-images";
    public static final String LOGIN_TRANSPORT_IMG_SMALL = "at-direct-bs-small-images";
    public static final String LOGIN_TRANSPORT_IMG_RETINA = "at-transport-image-retina"; //4 картинки форматов 640х100, 640x200, 640x960, 960х640
    public static final String LOGIN_TRANSPORT_IMG_REGULAR = "at-direct-bs-regular-images";
    public static final String LOGIN_TRANSPORT_IMG_NO_FORMATS = "at-direct-transport-img-nofrmt";
    public static final String LOGIN_TRANSPORT_IMG_AD = "at-transport-image-new";//пара картинок для ГО не "ретина"
    public static final String LOGIN_TRANSPORT_IMG_AD_WITH_OLD = "at-transport-image-new-old";//картинки для ГО не "ретина" и простой wide
    public static final String LOGIN_TRANSPORT_IMG = "at-direct-bs-different-images";
    public static final String LOGIN_TRANSPORT_NEW_RMP = "at-direct-bs-new-rmp-enabled"; // для проверки работы фичи new_rmp_enabled
    public static final String LOGIN_TRANSPORT_RM = "at-bs-rm-testing";
    public static final String LOGIN_TRANSPORT_RM2 = "at-bs-rm-testing2";
    public static final String LOGIN_TRANSPORT_EXTENDED_RM = "at-bs-extended-rm-allowed"; // для проверки работы фичи context_relevance_match_allowed
    public static final String LOGIN_TRANSPORT_SUM_MIGRATION = "at-transport-sum-migration";
    public static final String LOGIN_TRANSPORT_SUM_MIGRATION_2 = "at-transport-sum-migration-2";
    public static final String LOGIN_TRANSPORT_INTERNAL_ADS = "at-internal-ads";
    public static final String LOGIN_TRANSPORT_INTERNAL_ADS2 = "at-internal-ads2";
    public static final String LOGIN_TRANSPORT_INTERNAL_ADS3 = "at-internal-ads3";
    /**
     * клиент с wallet_campaigns.is_sum_aggregated = 'Yes'
     * + у него включена фича "создавать биллинговые агрегаты при создании кампании"
     */
    public static final String LOGIN_TRANSPORT_SUM_MIGRATION_3 = "at-transport-sum-migration-3";
    public static final String LOGIN_CLIENT_FLAGS = "at-direct-client-flags"; //для проверки флага clients_options.client_flags = "no_display_hrefs"
    public static final String LOGIN_INTEGRATION = "at-integration";
    public static final String LOGIN_INTEGRATION_2 = "at-integraton-2";
    public static final String LOGIN_YNDX_FIXED = "ollven30"; //Логин выпросил у ручников:) пользоваться будем только мы
    public static final String LOGIN_SUPER = "at-direct-super";
    public static final String LOGIN_RETARGETING = "at-intapi-retargeting";
    public static final String LOGIN_MNGR = "at-direct-transfer-mngr";
    public static final String LOGIN_AGENCY = "at-intapi-ag2";
    public static final String LOGIN_AGENCY_YNDX_FIXED = "at-direct-ag-full";
    //из-за запрета у.е-шников DIRECT-51545 создал белорусское агентство (ему можно создавать в у.е)
    public static final String LOGIN_AGENCY_YNDX_FIXED_BY = "at-intapi-ag3";
    /*
     Логин из второго шарда для проверки шардинговых методов
     */
    public static final String LOGIN_SHARDING = "at-intapi-sharding";
    public static final String LOGIN_WALLET = "at-intapi-wallet";
    public static final String LOGIN_WALLET_CAMPAIGNS_SUMS_FOR_BS = "at-intapi-wallet1";
    /**
     * клиент с заархивированными биллинговыми агрегатами
     */
    public static final String LOGIN_ARCHIVED_BILLING_AGGREGATES = "at-transport-archived-ba";

    public static final String LOGIN_CHF = "intapi-serv-chf";
    public static final String LOGIN_RUB = LOGIN_MAIN;
    public static final String LOGIN_EUR = "intapi-serv-eur";
    public static final String LOGIN_KZT = "intapi-serv-kzt";
    public static final String LOGIN_TRY = "intapi-serv-try";
    public static final String LOGIN_UAH = "intapi-serv-uah";
    public static final String LOGIN_USD = "intapi-serv-usd";
    public static final String LOGIN_BYN = "intapi-serv2-byn"; //TS, loadtest

    public static final String LOGIN_RUB1 = "at-intapi-test-rub";
    public static final String LOGIN_RUB2 = "at-intapi-test-rub1";
    public static final String LOGIN_RUB3 = "at-intapi-test-rub3";

    public static final String CLIENT_DATA_MAIN = "at-client-data-main";
    public static final String CLIENT_DATA_REP1 = "at-client-data-rep1";
    public static final String CLIENT_DATA_REP2 = "at-client-data-rep2";
    public static final String CLIENT_DATA_SINGLE = "at-client-data-single";

    public static final String CLIENT_DATA_AGENCY = "at-client-data-agg";
    public static final String CLIENT_DATA_AGENCY_REP = "at-client-data-ag-rep";
    public static final String CLIENT_DATA_AGENCY_REP_CLIENTS = "at-client-data-ag-rep-cl";

    public static final String CHECK_GOALS_CLIENT = "at-check-goals-client";
    public static final String CHECK_GOALS_CLIENT2 = "at-check-goals-client2";
    public static final String CHECK_GOALS_CLIENT3 = "at-check-goals-client3";
    public static final String CHECK_GOALS_CLIENT4 = "at-check-goals-client4";
    public static final String CHECK_GOALS_CLIENT5 = "at-check-goals-client5";
    public static final String CLIENT_WITH_NONEXISTENT_GOAL = "at-nonexistent-goal-client";

    public static final String UPDATE_DOCUMENT_CLIENT1 = "at-update-document-1";
    public static final String UPDATE_DOCUMENT_CLIENT2 = "at-update-document-2";
    public static final String UPDATE_DOCUMENT_CLIENT_ANOTHER_SHARD = "at-update-document-shard";

    public static final String PPC_FEED_TO_BANNER_LAND_1 = "feed-to-banner-land-1";
    public static final String PPC_FEED_TO_BANNER_LAND_2 = "feed-to-banner-land-2";
    public static final String PPC_FEED_TO_BANNER_LAND_3 = "feed-to-banner-land-3";
    public static final String PPC_FEED_TO_BANNER_LAND_4 = "feed-to-banner-land-4";
    public static final String PPC_FEED_TO_BANNER_LAND_5 = "feed-to-banner-land-5";
    public static final String PPC_FEED_TO_BANNER_LAND_6 = "feed-to-banner-land-6";
    public static final String PPC_FEED_TO_BANNER_LAND_7 = "feed-to-banner-land-7";

    public static final String AUTOPAY_LOGIN1 = "at-autopay-test-1";
    public static final String AUTOPAY_LOGIN2 = "at-autopay-test-2";
    public static final String AUTOPAY_LOGIN3 = "at-autopay-test-3";
    public static final String AUTOPAY_LOGIN4 = "at-autopay-test-4";
    public static final String AUTOPAY_LOGIN5 = "at-autopay-test-5";
    public static final String AUTOPAY_LOGIN6 = "at-autopay-test-6";
    public static final String AUTOPAY_LOGIN7 = "at-autopay-test-7";
    public static final String AUTOPAY_LOGIN8 = "at-autopay-test-8";
    public static final String AUTOPAY_LOGIN9 = "at-autopay-test-9";
    public static final String AUTOPAY_LOGIN10 = "at-autopay-test-10";
    public static final String AUTOPAY_LOGIN11 = "at-autopay-test-11";
    public static final String AUTOPAY_LOGIN12 = "at-autopay-test-12";
    public static final String AUTOPAY_LOGIN13 = "at-autopay-test-13";
    public static final String AUTOPAY_LOGIN14 = "at-autopay-test-14";
    public static final String AUTOPAY_LOGIN15 = "at-autopay-test-15";
    public static final String AUTOPAY_LOGIN16 = "at-autopay-test-16";
    public static final String AUTOPAY_LOGIN17 = "at-autopay-test-17";
    public static final String AUTOPAY_LOGIN18 = "at-autopay-test-18";
    public static final String AUTOPAY_LOGIN19 = "at-autopay-test-19";
    public static final String AUTOPAY_LOGIN_UAH = "at-autopay-test-uah";

    public static final String AUTOPAY_STATUS1 = "at-direct-autopaystatus-1";
    public static final String AUTOPAY_STATUS2 = "at-direct-autopaystatus-2";
    public static final String AUTOPAY_STATUS3 = "at-direct-autopaystatus-3";
    //Без ОС
    public static final String AUTOPAY_STATUS4 = "at-direct-autopaystatus-4";

    //Есть картинки для ГО
    public static final String LOGIN_MOD_TRANSPORT_2 = "at-transport-mod-2";

    public static final String LOGIN_MOD_TRANSPORT_1 = "at-transport-mod-1";
    public static final String LOGIN_MOD_TRANSPORT_3 = "at-transport-mod-3";
    public static final String LOGIN_MOD_TRANSPORT_4 = "at-transport-mod-4";
    public static final String LOGIN_MOD_TRANSPORT_5 = "at-transport-mod-5";
    public static final String LOGIN_MOD_TRANSPORT_6 = "at-transport-mod-6";
    public static final String LOGIN_MOD_TRANSPORT_7 = "at-transport-mod-7";
    public static final String LOGIN_MOD_TRANSPORT_8 = "at-transport-mod-8";
    public static final String LOGIN_MOD_TRANSPORT_9 = "at-transport-mod-9";
    public static final String LOGIN_MOD_TRANSPORT_10 = "at-transport-mod-10";
    public static final String LOGIN_MOD_TRANSPORT_CANVAS= "at-direct-mod-canvas";

    public static final String BUSINESS_UNIT1 = "at-direct-business-unit-1";
    public static final String BUSINESS_UNIT2 = "at-direct-business-unit2";
    public static final String BUSINESS_UNIT3 = "at-direct-business-unit3";

    public static final String LOGIN_CLEARCAMP1 = "at-direct-clearcamp-1"; //используется как "тестовый" с ОС
    public static final String LOGIN_CLEARCAMP2 = "at-direct-clearcamp-2"; //используется как "тестовый" без ОС
    public static final String LOGIN_CLEARCAMP3 = "at-direct-clearcamp-3"; //используется как "нетестовый" с ОС
    public static final String LOGIN_CLEARCAMP4 = "at-direct-clearcamp-4"; //используется как "нетестовый" с ОС

    public static final String NO_DIRECT_LOGIN = "no-direct-client";
    public static final String SUPER_READER = "at-direct-web-superreader";
    public static final String SUPPORT = "at-direct-support";
    public static final String PLACER = "at-direct-api-placer";
    public static final String TEAMLEADER = "at-direct-tl-full";

    //у этого клиента нет записи в таблице ppc.clients
    public static final String NO_CLIENTS_ENTRY_USER = "at-direct-no-clients-entry";
    //у этого клиента нет записи в таблице ppc.clients_options
    public static final String NO_CLIENTSOPTIONS_ENTRY_USER = "at-direct-no-clientsoptions";
    //у этого клиента нет записи как в pp.clients, так и в ppc.clients_options
    public static final String NO_CLIENTS_AND_CLIENTSOPTIONS_ENTRY_USER = "at-direct-no-cl-and-cloptions";

    public static HashMap<Role, String> roleLogins = new HashMap<Role, String>();

    static {
        roleLogins.put(Role.MANAGER, "robbiter-7912644139");
        roleLogins.put(Role.MEDIAPLANNER, "robbiter-2833512770");
        roleLogins.put(Role.PLACER, "robbiter-5081983084");
        roleLogins.put(Role.SUPER, "robbiter-6868059168");
        roleLogins.put(Role.SUPERREADER, "robbiter-4187855953");
        roleLogins.put(Role.SUPERTEAMLEADER, "robbiter-7412880324");
        roleLogins.put(Role.SUPPORT, "robbiter-6879837549");
        roleLogins.put(Role.TEAMLEADER, "robbiter-7911338895");
        roleLogins.put(Role.INTERNAL_ADMIN, "robbiter-7860195362");
        roleLogins.put(Role.INTERNAL_MANAGER, "robbiter-2647301264");
    }

    public static String getRoleLogin(Role role) {
        return roleLogins.get(role);
    }
}
