package ru.yandex.autotests.directapi.darkside.clients;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.darkside.connection.DarksideConfig;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;

/**
 * Created by omaz on 12.03.14.
 */
public abstract class BaseIntapiClient {
    protected Log localLogger = LogFactory.getLog(this.getClass());
    protected int connectionTimeoutMillis;

    private DarksideConfig config;
    private String attachmentTitle;


    protected BaseIntapiClient(DarksideConfig config, String attachmentTitle) {
        this.config = config;
        this.attachmentTitle = String.format("[%s]: Message", attachmentTitle);

        this.connectionTimeoutMillis =
                DirectTestRunProperties.getInstance().getDirectIntapiConnectionTimeoutMillis();
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    protected DarksideConfig getConfig() {
        return config;
    }

    protected void attachIntapiMessage(IntapiMessage intapiMessage) {
        localLogger.info(attachmentTitle);
        localLogger.info(intapiMessage.toString());
        AllureUtils.addJsonAttachment(attachmentTitle, intapiMessage.toString());
    }
}
