package ru.yandex.autotests.directapi.darkside.clients;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import ru.yandex.autotests.directapi.darkside.connection.DarksideConfig;

import java.net.URI;

/**
 * Created by omaz on 06.05.14.
 */
public class HttpsClient extends HttpClient {

    public HttpsClient(DarksideConfig config) {
        super(config);
        serviceUrl = config.getHost();
    }

    public HttpResponse sendGetRequestWithHeader(URI uri, String headerName, String headerValue) {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeader(headerName, headerValue);
        return sendRequest(httpGet);
    }

    public HttpResponse sendPostRequestWithHeader(URI uri, String headerName, String headerValue) {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader(headerName, headerValue);
        return sendRequest(httpPost);
    }

}
