package ru.yandex.autotests.directapi.darkside.clients;

import org.joda.time.Duration;

/**
 * @author xy6er
 * Date: 20.10.14
 * Describe message to/from server and log it in common way
 */
public class IntapiMessage {
    private String url;
    private String request;
    private String response;
    private String statusCode;
    private Long startTime;
    private Long endTime;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRequest() {
        return request;
    }

    public void setRequest(String request) {
        this.request = request;
        this.startTime = System.currentTimeMillis();
        this.endTime = null;
    }

    public String getResponse() {
        return response;
    }

    public void setResponse(String response) {
        this.endTime = System.currentTimeMillis();
        this.response = response;
    }

    public String getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("URL: " + url)
                .append("\n\n")
                .append("REQUEST: " + request)
                .append("\n\n");
        if (statusCode != null) {
            builder.append("STATUS CODE: " + statusCode)
                    .append("\n");
        }
        builder.append("RESPONSE: " + response);
        if (startTime != null) {
            if (endTime == null) {
                endTime = System.currentTimeMillis();
            }
            Duration duration = new Duration(startTime, endTime);

            builder.append("\n")
                    .append("DURATION: " + duration.getStandardSeconds())
                    .append(" sec");
        }
        return builder.toString();
    }

}
