package ru.yandex.autotests.directapi.darkside.connection;

import org.apache.http.client.utils.URIBuilder;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * User: omaz
 * Date: 26.08.13
 * Конфигуратор адресов сервисов
 */
public abstract class DarksideConfig {
    protected URI host;

    protected static final DirectTestRunProperties properties = DirectTestRunProperties.getInstance();

    public void setHost(String url) {
        try {
            URIBuilder builder = new URIBuilder(url);
            this.host = builder.build();
        } catch (URISyntaxException e) {
            throw new DarkSideException("Не удалось построить url", e);
        }
    }


    protected void setHost(URI url) {
        this.host = url;
    }

    public abstract URI getHost();

    protected URI setPath(String path) {
        URIBuilder builder = new URIBuilder(host);
        try {
            return builder.setPath(path).build();
        } catch (URISyntaxException e) {
            throw new DarkSideException("Не удалось построить url", e);
        }
    }

    protected URI path(String path) {
        URIBuilder builder = new URIBuilder(host);
        try {
            return builder.setPath(path).build();
        } catch (URISyntaxException e) {
            throw new DarkSideException("Не удалось построить url", e);
        }
    }

    protected URI scheme(String scheme) {
        URIBuilder builder = new URIBuilder(host);
        try {
            return builder.setScheme(scheme).build();
        } catch (URISyntaxException e) {
            throw new DarkSideException("Не удалось построить url", e);
        }
    }

    protected URI port(int port) {
        URIBuilder builder = new URIBuilder(host);
        try {
            return builder.setPort(port).build();
        } catch (URISyntaxException e) {
            throw new DarkSideException("Не удалось построить url", e);
        }
    }
}