package ru.yandex.autotests.directapi.darkside.connection;

import java.net.URI;
import java.net.URISyntaxException;

import org.apache.http.client.utils.URIBuilder;

import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;

/**
 * User: omaz
 * Date: 26.08.13
 * Конфигуратор адресов сервисов
 */
public class IntapiConfig extends DarksideConfig {
    static final String INTAPI_PREFIX = "intapi.";
    /**
     * intapi hosts:
     * http://test-direct.yandex.ru:9000
     * https://test-direct.yandex.ru:9443
     * http://test.direct.yandex.ru:9000
     * https://test.direct.yandex.ru:9443
     * https://8994.beta1.intapi.direct.yandex.ru:9443
     */
    public IntapiConfig() {
        super();
        String url = properties.getDirectIntapiHost();
        this.setHost(url);
        configure();
    }

    public IntapiConfig(String url) {
        super();
        this.setHost(url);
        configure();
    }

    public boolean isDirectIntapiStageTS(String url) {
        return
                url.contains("test-direct") ||
                        url.contains("test.direct.") ||
                        url.contains("test2-direct") ||
                        url.contains("ppctest-sandbox") ||
                        url.matches("^beta(\\d)\\..*") ||
                        url.matches("^ipv6-beta(\\d)\\..*");
    }
    public boolean isDirectIntapiStageTS() {
        return isDirectIntapiStageTS(host.toString());
    }

    /**
     * новая perl-ТС имеет другую схему адресации
     * DIRECTADMIN-8121
     */
    protected boolean injectServiceSubDomain() {
        if (this.host.toString().startsWith(INTAPI_PREFIX)) {
            return false;
        }
        String url = this.host.toString();
        return url.startsWith("test.direct.");
    }

    private void configure() {
        URIBuilder builder = new URIBuilder(host)
                .setScheme("http");
        if (isDirectIntapiStageTS(host.getHost())) {
            builder.setScheme("https");
            builder.setPort(9443);
        }

        configureHost(builder);

        try {
            setHost(builder.build());
        } catch (URISyntaxException e) {
            throw new DarkSideException("Не удалось построить url из адреса " + host, e);
        }
    }

    protected void configureHost(URIBuilder builder){}

    @Override
    public URI getHost() {
        return host;
    }

    public String getIPV6Host() {
        String ipv6Host = host.getHost();
        if(!ipv6Host.contains("ipv6")) {
            if (ipv6Host.contains("test")) {
                ipv6Host = ipv6Host.replaceFirst("test", "ipv6.test");
            } else if (ipv6Host.contains("beta")){
                ipv6Host = ipv6Host.replaceFirst("beta", "ipv6-beta");
            }
        }
        return ipv6Host;
    }

}

