package ru.yandex.autotests.directapi.darkside.connection;

import org.apache.http.client.utils.URIBuilder;

/**
 * User: omaz
 * Date: 26.08.13
 * Конфигуратор адресов сервисов
 */
public class IntapiHttpsConfig extends IntapiConfig {
    public IntapiHttpsConfig(String predefinedHost) {
        super(predefinedHost);
    }

    public IntapiHttpsConfig() {
        super();
    }

    @Override
    protected void configureHost(URIBuilder builder) {
        builder.setScheme("https");
        if (isDirectIntapiStageTS(host.getHost())) {
            builder.setPort(9443);
        }
        if (injectServiceSubDomain()) {
            builder.setHost(INTAPI_PREFIX + host.getHost());
        }
    }
}
