package ru.yandex.autotests.directapi.darkside.datacontainers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Экспериментальный контейнер для хранения идентификаторов созданных объектов. Нужен для проставления объектам статусов
 * Связи между объектами нет - есть просто список идентификаторов групп и баннеров и т.д.
 */
public class CreatedCampaignContainer {

    private Long cid;
    private List<Long> groupIds;
    private List<Long> keywordIds;
    private List<Long> bannerIds;
    private List<Long> adImageIds;
    private List<Long> creativeIds;

    public CreatedCampaignContainer() {
        this.groupIds = Collections.emptyList();
        this.keywordIds = Collections.emptyList();
        this.bannerIds = Collections.emptyList();
        this.adImageIds = Collections.emptyList();
        this.creativeIds = Collections.emptyList();
    }

    public Long getCid() {
        return cid;
    }

    public CreatedCampaignContainer withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    /**
     * Получить id группы. Предпологается, что в кампании одна группа, иначе надо использовать метод getGroupIds()
     */
    public Long getGroupId() {
        assumeThat("в кампании одна группа", groupIds, hasSize(1));
        return groupIds.get(0);
    }

    public List<Long> getGroupIds() {
        return groupIds;
    }

    public CreatedCampaignContainer withGroupIds(Long... groupIds) {
        this.groupIds = Arrays.asList(groupIds);
        return this;
    }

    /**
     * Получить id ключевика. Предпологается, что в группе один ключевик, иначе надо использовать метод getKeywordIds()
     */
    public Long getKeywordId() {
        assumeThat("в кампании один ключевик", keywordIds, hasSize(1));
        return keywordIds.get(0);
    }

    public List<Long> getKeywordIds() {
        return keywordIds;
    }

    public CreatedCampaignContainer withKeywordIds(Long... keywordIds) {
        this.keywordIds = Arrays.asList(keywordIds);
        return this;
    }

    /**
     * Получить id баннера. Предпологается, что в группе один баннер, иначе надо использовать метод getBannerIds()
     */
    public Long getBannerId() {
        assumeThat("в кампании один баннер", bannerIds, hasSize(1));
        return bannerIds.get(0);
    }

    public List<Long> getBannerIds() {
        return bannerIds;
    }

    public CreatedCampaignContainer withBannerIds(Long... bannerIds) {
        this.bannerIds = Arrays.asList(bannerIds);
        return this;
    }

    /**
     * Получить id adImage-а. Предпологается, что в кампании один adImage, иначе надо использовать метод getAdImageHashes()
     */
    public Long getAdImageId() {
        assumeThat("в кампании один adImage", adImageIds, hasSize(1));
        return adImageIds.get(0);
    }

    public List<Long> getAdImageIds() {
        return adImageIds;
    }

    public CreatedCampaignContainer withAdImageIds(Long... adImageIds) {
        this.adImageIds = Arrays.asList(adImageIds);
        return this;
    }

    /**
     * Получить id креатива. Предпологается, что в кампании один креатив, иначе надо использовать метод getCreativeIds()
     */
    public Long getCreativeId() {
        assumeThat("в кампании один креатив", creativeIds, hasSize(1));
        return creativeIds.get(0);
    }

    public List<Long> getCreativeIds() {
        return creativeIds;
    }

    public CreatedCampaignContainer withCreativeIds(Long... creativeIds) {
        this.creativeIds = Arrays.asList(creativeIds);
        return this;
    }
}
