package ru.yandex.autotests.directapi.darkside.datacontainers;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getKey;

/**
 * Created by buhter on 30/05/16.
 */
public enum DarksideTextConstants implements ITextResource {
    INCORRECT_ARGS,
    INCORRECT_PARAMS,
    DOMAINS_SHOULD_BE_ARRAY,
    NO_DOMAINS_PROVIDED,
    DOMAINS_ARRAY_IS_TOO_LONG,
    BL_ERROR_FETCH_FAILED,
    BL_ERROR_YML_NO_MODEL_OR_TAG_NAME,
    BL_ERROR_XML_FATAL,
    BL_ERROR_XML_NO_OFFERS,
    BL_ERROR_XML_NO_CATEGORIES,
    BL_ERROR_YML_NO_URL_TAG,
    BL_ERROR_YML_EMPTY_FILE,
    BL_ERROR_FEED_DATA_TYPE_MISMATCH,
    BL_ERROR_FILE_TOO_BIG,
    BL_ERROR_FATAL,
    CAMP_AUTOPAY_STATUS_UID_NOT_CLIENT,
    CAMP_AUTOPAY_STATUS_UID_OR_CLIENT_ID,
    CAMP_AUTOPAY_STATUS_NO_UID_OR_CLIENT_ID,
    CAMP_AUTOPAY_STATUS_INVALID_UID,
    CAMP_AUTOPAY_STATUS_INVALID_CLIENT_ID,
    CAMP_AUTOPAY_STATUS_CANT_FIND_CHIEF,
    UPDATE_FLAGS_MISSING_DISCLAIMER,
    UPDATE_FLAGS_INVALID_BID,
    PROCESS_MOD_RESULT_NO_FORCE_OR_VERSION_ERROR_TEXT,
    PROCESS_MOD_RESULT_NO_FORCE_OR_VERSION_ERROR,
    PPC_CAMP_GET_GOALS_MANY_INVALID_LINES;

    private static String BUNDLE = "intapi.DarksideTextConstants";
    private String locale = "en";

    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return getKey(this);
    }

    public String getText() {
        return TextResourceFormatter
                .resource(this)
                .locale(DirectTestRunProperties.getInstance().getDirectAPILocale() == null
                        ? locale : DirectTestRunProperties.getInstance().getDirectAPILocale())
                .toString();
    }

    public String getText(Object... params) {
        return TextResourceFormatter
                .resource(this)
                .args(params)
                .locale(DirectTestRunProperties.getInstance().getDirectAPILocale() == null
                        ? locale : DirectTestRunProperties.getInstance().getDirectAPILocale())
                .toString();
    }
}
