package ru.yandex.autotests.directapi.darkside.datacontainers.http.request;

import java.util.HashMap;

public class ActiveBannersRequest extends HashMap<String, String> {
    static final String MIN_CID = "min_cid";
    static final String MAX_CID = "max_cid";
    static final String LIMIT = "limit";

    public ActiveBannersRequest withLimit(Integer limit) {
        put(LIMIT, String.valueOf(limit));
        return this;
    }

    public ActiveBannersRequest withMinCid(Long minCid) {
        put(MIN_CID, String.valueOf(minCid));
        return this;
    }

    public ActiveBannersRequest withMaxCid(Long maxCid) {
        put(MAX_CID, String.valueOf(maxCid));
        return this;
    }
}
