package ru.yandex.autotests.directapi.darkside.datacontainers.http.request;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.HashMap;

/**
 * Created by omaz on 24.01.14.
 * конструктор параметров для метода AllBannersPhrases
 */
public class AllBannersPhrasesRequest extends HashMap<String, String> {
    DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyyMMddHHmmss");

    //region param names
    static final String LAST_CHANGE = "LastChange";
    static final String LAST_BID = "LastBid";
    static final String CHUNK = "chunk";
    static final String TEMPLATE = "template";
    static final String IDS = "ids";
    static final String API_VERSION = "v";
    static final String LIMIT = "limit";
    static final String TIME_GAP = "time_gap";
    //endregion

    //region builder
    public AllBannersPhrasesRequest defaultParams() {
        return this
                .withTemplate(true)
                .withApiVersion(3);
    }

    public AllBannersPhrasesRequest withLastChange(DateTime dateTime) {
        put(LAST_CHANGE, dateTime.toString(formatter));
        return this;
    }

    public AllBannersPhrasesRequest withLastBid(Long lastBid) {
        put(LAST_BID, String.valueOf(lastBid));
        return this;
    }

    public AllBannersPhrasesRequest withChunk(Integer chunkNumber, Integer chunkCount) {
        put(CHUNK, String.valueOf(chunkNumber) + "/" + String.valueOf(chunkCount));
        return this;
    }

    public AllBannersPhrasesRequest withTemplate(Boolean template) {
        put(TEMPLATE, template ? "1" : "0");
        return this;
    }

    public AllBannersPhrasesRequest withIds(Boolean ids) {
        put(IDS, ids ? "1" : "0");
        return this;
    }

    public AllBannersPhrasesRequest withApiVersion(Integer version) {
        put(API_VERSION, String.valueOf(version));
        return this;
    }

    public AllBannersPhrasesRequest withLimit(Integer limit) {
        put(LIMIT, String.valueOf(limit));
        return this;
    }

    public AllBannersPhrasesRequest withTimeGap(Integer timeGap) {
        put(TIME_GAP, String.valueOf(timeGap));
        return this;
    }
    //endregion


}
