package ru.yandex.autotests.directapi.darkside.datacontainers.http.request;

import java.util.HashMap;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.irt.testutils.RandomUtils;

/**
 * Created by hmepas on 27.03.17
 */
public class ClientsCreateRequest extends HashMap<String, String> {
    static String AGENCY_LOGIN = "agency_login";
    static String MANAGER_LOGIN = "manager_login";

    static String LOGIN = "login";
    static String NAME = "name";
    static String SURNAME = "surname";
    static String CURRENCY = "currency";
    static String COUNTRY = "country";

    public static ClientsCreateRequest getDefaultClientCreateRequest() {
        return new ClientsCreateRequest()
                .withLogin("at-some-user")
                .withName("John")
                .withSurname("Donne")
                .withCountry("225")
                .withCurrency(Currency.RUB);
    }

    public static ClientsCreateRequest getDefaultRandomLoginRubClientCreateRequest() {
        return getDefaultRandomLoginClientCreateRequest().withCurrency(Currency.RUB);
    }

    public static ClientsCreateRequest getDefaultRandomLoginClientCreateRequest() {
        final String login = "at-cl-" + RandomUtils.getString(14);
        return getDefaultClientCreateRequest().withLogin(login);
    }

    public ClientsCreateRequest withAgencyLogin(String agencyLogin) {
        this.put(AGENCY_LOGIN, agencyLogin);
        return this;
    }

    public ClientsCreateRequest withManagerLogin(String managerLogin) {
        this.put(MANAGER_LOGIN, managerLogin);
        return this;
    }

    public ClientsCreateRequest withLogin(String login) {
        this.put(LOGIN, login);
        return this;
    }

    public ClientsCreateRequest withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public ClientsCreateRequest withSurname(String surname) {
        this.put(SURNAME, surname);
        return this;
    }

    public ClientsCreateRequest withCurrency(String currencyName) {
        this.put(CURRENCY, currencyName);
        return this;
    }
    public ClientsCreateRequest withCurrency(Currency currency) {
        this.put(CURRENCY, currency.toString());
        return this;
    }
    public ClientsCreateRequest withCountry(String country) {
        this.put(COUNTRY, country);
        return this;
    }
}
