package ru.yandex.autotests.directapi.darkside.datacontainers.http.request;

import ru.yandex.autotests.directapi.darkside.model.Role;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.HashMap;

/**
 * Created by omaz on 12.02.14.
 * контейнер запроса к idm/add-role и idm/remove-role
 */
public class DostupRemoveRoleRequest extends HashMap<String, String> {
    private static final String LOGIN = "login";
    private static final String ROLE = "role";
    private static final String DATA = "data";

    public DostupRemoveRoleRequest withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public DostupRemoveRoleRequest withPassportLogin(String passportLogin) {
        PassportLoginData passportLoginData = new PassportLoginData(passportLogin);
        put(DATA, JsonUtils.toString(passportLoginData));
        return this;
    }

    public DostupRemoveRoleRequest withRole(Role role) {
        RoleRequestData roleRequestData = new RoleRequestData(role);
        put(ROLE, JsonUtils.toString(roleRequestData));
        return this;
    }

    public DostupRemoveRoleRequest withRole(String roleName) {
        RoleRequestData roleRequestData = new RoleRequestData(roleName);
        put(ROLE, JsonUtils.toString(roleRequestData));
        return this;
    }

}
